#!/usr/bin/env python

from setuptools import setup
import platform

DEFINE_VERSION = '8.3'

'''
install tools:

1.apachetop
2.ngxtop
3.pywget
4.htop
5.pykill
'''

system = platform.system()

#yum install begin.
if system == 'Linux':
    cmd = 'yum install -y python-devel libffi libffi-devel openssl openssl-devel apachetop htop'
    import commands
    commands.getstatusoutput(cmd)
    print cmd
#yum install end.

#add pywget to /usr/bin begin.
pywget_code = """#!/usr/bin/env python

import sys
import commands

def execmd(cmdString):
    status, output = commands.getstatusoutput(cmdString)
    return status, output

if __name__ == '__main__':
    argv = sys.argv
    for args in argv:
        if 'https' in args:
            argv.append('--no-check-certificate')
            break
    argv[0] = 'wget'
    cmd = ' '.join(argv)
    _, output = execmd(cmd)
    print output"""

if system == 'Linux':
    try:
        f = open('/usr/bin/pywget', 'w')
        f.write(pywget_code)
        f.close()
        print 'copy pywget to /usr/bin'
        cmd = 'chmod 777 /usr/bin/pywget'
        commands.getstatusoutput(cmd)
        print cmd
    except Exception, ex:
        print 'Warning:' + str(ex)
#add pywget to /usr/bin end.

setup(
    name='agileutil',
    version=DEFINE_VERSION,
    description='python lib',
    author='lyc',
    license='MIT',
    platforms = "any",
    install_requires=[
        'cryptography==2.0.0',
        'python-decouple>=3.1',
        'PyMySQL>=0.7.11', 
        'redis>=2.10.6', 
        'requests>=2.12.1', 
        'web.py>=0.38',
        'demjson>=2.2.4', 
        'pexpect>=4.3.0', 
        'fabric>=1.14.0', 
        'IPy>=0.83', 
        'ansible==1.9.1',
        'tqdm>=4.19.4', 
        'paramiko>=2.3.1',
        'pika>=0.10.0',
        'gevent==1.1',
        'gunicorn>=19.6.0',
        'phpserialize',
        'pymongo',
        'fire',
        'ngxtop',
        'rpyc',
        'pykill',
        'flask',
        'envelopes'
    ],
    classifiers=[
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
    ],
    keywords='agileutil',
    packages=['agileutil'],
    include_package_data=True
)