
help_msg = '''
Get qrcode from a string

Usage:
    meteor qrcode "http://www.google.com"
'''

def config(parser):
    parser.set_defaults(func=action)
    parser.add_argument('string', help='string to convert to')

def action(args):

    import os
    import tempfile
    temp_dir = os.path.join(tempfile.gettempdir(), 'meteor')
    if not os.path.isdir(temp_dir):
        os.mkdir(temp_dir)

    imgpath = os.path.join(temp_dir, 'qrcode.png')

    import qrcode
    string = args.string
    img = qrcode.make(string)
    img.save(imgpath)
    os.startfile(imgpath)

