#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'Click>=6.0',
    # TODO: put package requirements here
]

test_requirements = [
    # TODO: put package test requirements here
]

setup(
    name='pybe',
    version='0.1.2',
    description="PyBE is a library for solving biosystems engineering problems.",
    long_description=readme + '\n\n' + history,
    author="Kurt Kremitzki",
    author_email='kkremitzki@gmail.com',
    url='https://gitlab.com/pybe/pybe',
    packages=[
        'pybe',
    ],
    package_dir={'pybe':
                 'pybe'},
    entry_points={
        'console_scripts': [
            'pybe=pybe.cli:main'
        ]
    },
    include_package_data=True,
    install_requires=requirements,
    license="BSD license",
    zip_safe=False,
    keywords='pybe',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
    ],
    test_suite='tests',
    tests_require=test_requirements
)
