# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationResult(Model):
    """An Operation Result.

    :param status: The operation status.
    :type status: str
    :param status_code: The status code for the operation. Possible values
     include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted',
     'NonAuthoritativeInformation', 'NoContent', 'ResetContent',
     'PartialContent', 'MultipleChoices', 'MovedPermanently', 'Redirect',
     'SeeOther', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect',
     'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound',
     'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired',
     'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired',
     'PreconditionFailed', 'RequestEntityTooLarge', 'RequestUriTooLong',
     'UnsupportedMediaType', 'RequestedRangeNotSatisfiable',
     'ExpectationFailed', 'UpgradeRequired', 'InternalServerError',
     'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout',
     'HttpVersionNotSupported'
    :type status_code: str or ~azure.mgmt.devtestlabs.models.HttpStatusCode
    :param error: Error details for the operation in case of a failure.
    :type error: ~azure.mgmt.devtestlabs.models.OperationError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'error': {'key': 'error', 'type': 'OperationError'},
    }

    def __init__(self, status=None, status_code=None, error=None):
        self.status = status
        self.status_code = status_code
        self.error = error
