# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class GatewayResource(Resource):
    """GatewayResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: ARM Resource ID
    :vartype id: str
    :ivar type: ARM Resource Type
    :vartype type: str
    :ivar name: ARM Resource Name
    :vartype name: str
    :ivar location: ARM Resource Location
    :vartype location: str
    :param tags: ARM Resource Tags
    :type tags: dict
    :param etag:
    :type etag: str
    :param created: UTC date and time when gateway was first added to
     management service
    :type created: datetime
    :param updated: UTC date and time when node was last updated
    :type updated: datetime
    :param auto_upgrade: setting of the autoupgrade. Possible values include:
     'On', 'Off'
    :type auto_upgrade: str or :class:`AutoUpgrade
     <azure.mgmt.servermanager.models.AutoUpgrade>`
    :param desired_version: latest available msi version
    :type desired_version: str
    :param instances: names of the nodes in the gateway
    :type instances: list of :class:`GatewayStatus
     <azure.mgmt.servermanager.models.GatewayStatus>`
    :param active_message_count: number of active messages
    :type active_message_count: int
    :param latest_published_msi_version: last published msi version
    :type latest_published_msi_version: str
    :param published_time_utc: the date/time of the last published gateway
    :type published_time_utc: datetime
    """ 

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'auto_upgrade': {'key': 'properties.autoUpgrade', 'type': 'AutoUpgrade'},
        'desired_version': {'key': 'properties.desiredVersion', 'type': 'str'},
        'instances': {'key': 'properties.instances', 'type': '[GatewayStatus]'},
        'active_message_count': {'key': 'properties.activeMessageCount', 'type': 'int'},
        'latest_published_msi_version': {'key': 'properties.latestPublishedMsiVersion', 'type': 'str'},
        'published_time_utc': {'key': 'properties.publishedTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, tags=None, etag=None, created=None, updated=None, auto_upgrade=None, desired_version=None, instances=None, active_message_count=None, latest_published_msi_version=None, published_time_utc=None):
        super(GatewayResource, self).__init__(tags=tags, etag=etag)
        self.created = created
        self.updated = updated
        self.auto_upgrade = auto_upgrade
        self.desired_version = desired_version
        self.instances = instances
        self.active_message_count = active_message_count
        self.latest_published_msi_version = latest_published_msi_version
        self.published_time_utc = published_time_utc
