'''OpenGL extension VERSION.GL_1_4

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_1_4 to provide a more 
Python-friendly API
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.VERSION.GL_1_4 import *
### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy
from OpenGL.GL.pointers import glDrawElements
#glMultiDrawElements = wrapper.wrapper( glMultiDrawElements ).setPyConverter(
#	'indices', arrays.AsArrayOfType( 'indices', 'type' ),
#).setCResolver( 
#	'indices', arrays.ArrayDatatype.voidDataPointer ,
#).setPyConverter(
#	'count', arrays.AsArrayTyped( 'count', arrays.GLsizeiArray ),
#).setCResolver(
#	'count', arrays.ArrayDatatype.voidDataPointer ,
#)

@lazy( glMultiDrawElements )
def glMultiDrawElements(baseOperation, primtype, counts, typ, indices, primcount):
	"""Currently glMultiDrawElements is not working in the wrapper 
	
	We are replacing the code with a sequence of glDrawElements calls
	as per the spec for the function...
	"""
	for i in xrange( primcount ):
		glDrawElements( primtype, counts[i], typ, indices[i] )
