
ABP, alternating bit protocol
=============================

This sample models the *alternating bit protocol*, a simple network
protocol that retransmits lost or corrupted messages (see
[Wikipedia](http://en.wikipedia.org/wiki/Alternating_bit_protocol).

This model is a Finite State Machine (FSM).  For this simple system,
it is not necessary to write a model program.  This sample shows that
an FSM can be used as the model (not just as a scenario machine).  Just
like a model program, an FSM can generate traces, generate graphics, and
be composed with test suites.

The modules are:

- *ABP*: FSM that models the alternating bit protocol

- *Scenarios*: test suite with two traces, one allowed by the protocol,
  another not

- *test*: test cases with *ABP* that demontrate *pmt* options and the
  built-in *ActionNameCoverage* strategy

- *test_graphics*: generates *ABP.svg* directly from the *ABP* FSM
  using *pmg* without using *pma*, also generates *ABPFSM.svg* from *ABP* using
  *pma*, then *pmg*

- *test_scenarios*: executes *Scenarios* by itself, then composed with *ABP* to 
  reveal that the second trace is not allowed by the model.

- *fsmpy*, *svg*: directories of *FSM.py* and *.svg* files generated by the 
  test scripts.

You can view the *.svg* files in a browser.

- *ABP*: graph of the FSM, generated directly from *ABP.py* by *pmg*

- *ABPFSM*: another graph of the FSM, generated from *ABP.py* by
   *pma*, then *pmg*

There is no stepper in this sample.


Revised Apr 2013
