# This file was auto-generated by zetup
#
# https://bitbucket.org/userzimmermann/zetup.py


from __future__ import absolute_import

import sys
import os
from collections import OrderedDict

from zetup.version import Version
from zetup.dist import Distribution
from zetup.requires import Requirements
from zetup.extras import Extras
from zetup.package import Packages, Package
from zetup.notebook import Notebook



zfg = sys.modules[__name__]

NAME = 'modeled'

DESCRIPTION = 'Universal data modeling for Python.'

CLASSIFIERS = ['Development Status :: 3 - Alpha', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)', 'Operating System :: OS Independent', 'Topic :: Software Development', 'Topic :: Utilities', 'Programming Language :: Python', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4']

NO_MAKE = []

KEYWORDS = ['modeled', 'model', 'modeling', 'modelled', 'modelling', 'serialization', 'exchange', 'mapping', 'class', 'object', 'member', 'property', 'typed', 'ctypes', 'cfunc', 'funcptr', 'python3']

VERSION = Version('0.1.8')

AUTHOR = 'Stefan Zimmermann'

EMAIL = 'zimmermann.code@gmail.com'

REQUIRES = Requirements("""
zetup >= 0.2.27
six >= 1.9
path.py >= 8.0 #import path
moretools >= 0.1.7

""", zfg=zfg)

URL = 'https://bitbucket.org/userzimmermann/python-modeled'

SETUP_HOOKS = []

MODULES = []

EXTRAS = Extras([

], zfg=zfg)

TITLE = 'modeled'

FORCE_MAKE = True

LICENSE = 'LGPLv3'

KEEP_MADE = ['setup.py', 'tox.ini']

PYTHON = ['2.7', '3.3', '3.4']

SCRIPTS = None

SETUP_REQUIRES = None

DISTRIBUTION = Distribution(zfg)

PACKAGES = Packages([

Package('modeled',
  sources=[
    'adapter.py',
    'api.py',
    'base.py',
    'datetime.py',
    'dict.py',
    'extension.py',
    'list.py',
    'meta.py',
    'model.py',
    'namedtuple.py',
    'object.py',
    'options.py',
    'range.py',
    'simpledict.py',
    'tuple.py',
    'typed.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('modeled.cfunc',
  sources=[
    'arg.py',
    'model.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('modeled.member',
  sources=[
    'context.py',
    'dict.py',
    'handlers.py',
    'list.py',
    'tuple.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('modeled.property',
  sources=[
    'dict.py',
    'list.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )

  ], root=os.path.dirname(os.path.dirname(os.path.realpath(__file__))))

TEST_COMMANDS = ['py.test -v test']

SETUP_KEYWORDS = None