import time,re

time_format = "%Y/%m/%d %I:%M %p"

class Message():
	def __init__(self, pType, pMessage, pTime=None):
		self.type = pType
		self.message = pMessage
		if pTime is None:
			self.time = time.localtime()
		else:
			self.time = pTime
	
	
	def __str__(self):
		return " | ".join((time.strftime(time_format, self.time),self.type,self.message))
	

def parseMessage(string):
	pattern = r"^(?P<time>[^|]*) [|] (?P<type>[^|]*) [|] (?P<message>.*)$"
	match  = re.search(pattern ,string)
	if match:
		msg_type,msg_message = match.group('type', 'message')
		msg_time = time.strptime(match.group('time'), time_format)
		return Message(msg_type, msg_message, pTime = msg_time)
	else:
		return None