import argparse, sys
import jl.dispatcher

class CMDParser(argparse.ArgumentParser):
	def error(self, message):
		print("Command not found, use help for more options")
		#self.print_help(sys.stderr)
		#self.exit(2, '%s: error: %s\n' % (self.prog, message))


def get_parser(addinit=False,cmd=False):
	if cmd:
		parser = CMDParser(description='Process JL')
	else:
		parser = argparse.ArgumentParser(description='Process JL')
	#parser.error = error
	
	subparsers = parser.add_subparsers()
	
	#add parser
	parser_add = subparsers.add_parser('add', help = 'adds a message')
	parser_add.add_argument('type', type=str, help = 'type of message')
	parser_add.add_argument('message', type=str, help = 'message text')
	parser_add.set_defaults(func=jl.dispatcher.add)
	
	#filter parser
	parser_filter = subparsers.add_parser('filter', help = 'filters existing messages')
	parser_filter.add_argument('-m', '--multi', action='store_true', help="Searches over every file, not just current day's")
	parser_filter.add_argument('-c', '--count', type=int, help='Number of messages to return')
	parser_filter.add_argument('-r', '--reverse', action='store_true', help='Reverses sort order')
	parser_filter.add_argument('types', nargs='*', help = 'types to search for')
	parser_filter.set_defaults(func=jl.dispatcher.fltr)
	
	#tail parser
	parser_tail = subparsers.add_parser('tail', help = 'returns all messages')
	parser_tail.add_argument('-m', '--multi', action='store_true', help="Searches over every file, not just current day's")
	parser_tail.add_argument('-c', '--count', type=int, help='Number of messages to return')
	parser_tail.add_argument('-r', '--reverse', action='store_true', help='Reverses sort order')
	parser_tail.set_defaults(func=jl.dispatcher.tail)
	
	#init parser
	if addinit:
		parser_init = subparsers.add_parser('init', help = 'Initiates JL in current directory')
		parser_init.set_defaults(func=jl.dispatcher.init)
	
	return parser


def error(self, message):
    self.print_help(sys.stderr)
    #self.exit(2, '%s: error: %s\n' % (self.prog, message))
