#!/usr/bin/python
import os,time,errno

def _getFilePath():
	return os.getcwd()+"/.jl/" 

def _getFilename():
	return _getFilePath() + time.strftime("jl%Y%m%d") + ".txt"

def add(message_string):
	with open(_getFilename(), 'a+') as fileh:
		fileh.write(message_string)
	
def get_file_lines(filename):
	with open(filename) as fileh:
		lines = fileh.readlines()
	
	lines = [x.strip() for x in lines if bool(x) and x!="\n"]
	return lines

def get_today_lines():
	return get_file_lines(_getFilename())

def get_all_lines():
	path = _getFilePath()
	all_lines = map(get_file_lines, map(lambda x: path + x, os.listdir(path)))
	return [line for file_lines in all_lines for line in file_lines]

def get_lines(multi_file = False):
	if multi_file:
		return get_all_lines()
	else:
		return get_today_lines()


def init():
	try:
		os.makedirs(_getFilePath())
	except OSError as exception:
		if exception.errno != errno.EEXIST:
			raise
		else:
			print("JL already initiated")
