import jl.message, jl.filemanager


def _matches(string, filter_list):
	msg = jl.message.parseMessage(string)
	if "*" in filter_list:
		return True
	else:
		for option in filter_list:
			if option.lower() in msg.type.lower():
				return True
	return False
	
def add(message):
	print("Writing...\n")
	print(str(message))
	jl.filemanager.add(str(message) + "\n")

def fltr(filter_list, multi=False, count=None, reverse=False):
	lines = jl.filemanager.get_lines(multi)
	lines = [line for line in lines if _matches(line, filter_list)]
	if len(lines)==0:
		print("No lines matched criteria")
	
	#handle reverse
	if reverse:
		lines.reverse()		
	
	#count logic, could be improved. Also, from which end should count go?
	if count is None:
		pass
	else:
		if len(lines) < count:
			pass
		else:
			lines = lines[-count:]
	
	for line in lines:
		print(line.strip())
		
def init():
	jl.filemanager.init()
