import jl.jlparser
import shlex
import cmd

class JLCmd(cmd.Cmd):
	EXITS = ["quit","exit","q"]
	SEPARATOR = "-"*80
	
	prompt="\Jl: "
	
	def precmd(self, string):
		if len(string)>=1: 
			print(self.SEPARATOR)
		return string
	
	def postcmd(self, stop, string):
		print(self.SEPARATOR)
		return stop
	
	def onecmd(self, string):
		prsr = jl.jlparser.get_parser(False, True)
		
		args = shlex.split(string)
		
		if len(args) < 1:
			return
		
		if args[0] in self.EXITS:
			exit(0)
		elif args[0]=='help':
			prsr.print_help()
			return
		
		try:
			parsed_args = prsr.parse_args(args)
		except:
			parsed_args = None
		
		if parsed_args:
			return parsed_args.func(parsed_args)
		
	

def main():
	JLCmd().cmdloop("Use 'help' to see some options to get started.")
	
	