# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class File(Model):
    """Properties of the file.

    :param name: file name
    :type name: str
    :param download_url: file downloand url, example:
     https://mystg.blob.core.windows.net/mycontainer/myModel_1.dnn. This will
     be returned only if the model has been archived. During job run, this
     won't be returned and customers can use SSH tunneling to download. Users
     can use Get Remote Login Information API to get the IP address and port
     information of all the compute nodes running the job.
    :type download_url: str
    :param last_modified: The time at which the file was last modified. The
     time at which the file was last modified.
    :type last_modified: datetime
    :param content_length: The file size. The file size.
    :type content_length: long
    """

    _validation = {
        'name': {'required': True},
        'download_url': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'download_url': {'key': 'downloadUrl', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'content_length': {'key': 'properties.contentLength', 'type': 'long'},
    }

    def __init__(self, name, download_url, last_modified=None, content_length=None):
        self.name = name
        self.download_url = download_url
        self.last_modified = last_modified
        self.content_length = content_length
