/*
 * Decompiled with CFR 0.152.
 */
package be.re.net;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Headers {
    private List headers = new ArrayList();

    public void add(String name, String value) {
        this.headers.add(new Header(name, value));
    }

    public void add(Headers headers) {
        Header[] all = headers.getAll();
        for (int i = 0; i < all.length; ++i) {
            this.add(all[i].getName(), all[i].getValue());
        }
    }

    public void clear() {
        this.headers.clear();
    }

    public String[] get(String name) {
        ArrayList<String> values = new ArrayList<String>();
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            Header tuple = (Header)i.next();
            if (!tuple.name.equalsIgnoreCase(name)) continue;
            values.add(tuple.value);
        }
        return values.toArray(new String[values.size()]);
    }

    public Header[] getAll() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public void remove(String name) {
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            Header tuple = (Header)i.next();
            if (!tuple.name.equalsIgnoreCase(name)) continue;
            i.remove();
        }
    }

    public void remove(String name, String value) {
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            Header tuple = (Header)i.next();
            if (!tuple.name.equalsIgnoreCase(name) || !tuple.value.equals(value)) continue;
            i.remove();
        }
    }

    public void set(String name, String value) {
        this.remove(name);
        this.add(name, value);
    }

    public void set(String name, String oldValue, String newValue) {
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            Header tuple = (Header)i.next();
            if (!tuple.name.equalsIgnoreCase(name) || !tuple.value.equals(oldValue)) continue;
            tuple.value = newValue;
        }
    }

    public int size() {
        return this.headers.size();
    }

    public String toString() {
        String result = "";
        Iterator i = this.headers.iterator();
        while (i.hasNext()) {
            Header tuple = (Header)i.next();
            result = result + tuple.name + ":" + tuple.value + "\r\n";
        }
        return result;
    }

    public class Header {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

