/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class OrExpression
extends BooleanExpression {
    public OrExpression(Expression p1, Expression p2) {
        super(p1, 9, p2);
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (e != this) {
            return e;
        }
        if (Literal.isConstantBoolean(this.operand0, true) || Literal.isConstantBoolean(this.operand1, true)) {
            return Literal.makeLiteral(BooleanValue.TRUE, this.getContainer());
        }
        if (Literal.isConstantBoolean(this.operand0, false)) {
            return this.forceToBoolean(this.operand1, th);
        }
        if (Literal.isConstantBoolean(this.operand1, false)) {
            return this.forceToBoolean(this.operand0, th);
        }
        return this;
    }

    public Expression copy() {
        return new OrExpression(this.operand0.copy(), this.operand1.copy());
    }

    public Expression negate() {
        NotFn not0 = (NotFn)SystemFunctionCall.makeSystemFunction("not", new Expression[]{this.operand0});
        NotFn not1 = (NotFn)SystemFunctionCall.makeSystemFunction("not", new Expression[]{this.operand1});
        return new AndExpression(not0, not1);
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        return this.operand0.effectiveBooleanValue(c) || this.operand1.effectiveBooleanValue(c);
    }
}

