# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class QuizsubmissionsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: complete_quiz_submission_turn_it_in
    def complete_quiz_submission_turn_it_in(self, course_id, quiz_id, id, attempt, validation_token, **kwargs):
        """
        Complete the quiz submission (turn it in).
        Complete the quiz submission by marking it as complete and grading it. When the quiz submission has been marked as complete, no further modifications will be allowed.  <b>Responses</b>  * <b>200 OK</b> if the request was successful * <b>403 Forbidden</b> if an invalid access code is specified * <b>403 Forbidden</b> if the Quiz's IP filter restriction does not pass * <b>403 Forbidden</b> if an invalid token is specified * <b>400 Bad Request</b> if the QS is already complete * <b>400 Bad Request</b> if the attempt parameter is missing * <b>400 Bad Request</b> if the attempt parameter is not the latest attempt

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.complete_quiz_submission_turn_it_in_with_http_info(course_id, quiz_id, id, attempt, validation_token, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str id: ID (required)
        :param int attempt: The attempt number of the quiz submission that should be completed. Note that this must be the latest attempt index, as earlier attempts can not be modified. (required)
        :param str validation_token: The unique validation token you received when this Quiz Submission was created. (required)
        :param str access_code: Access code for the Quiz, if any.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id', 'attempt', 'validation_token', 'access_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_quiz_submission_turn_it_in" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `complete_quiz_submission_turn_it_in`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `complete_quiz_submission_turn_it_in`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `complete_quiz_submission_turn_it_in`")
        # verify the required parameter 'attempt' is set
        if ('attempt' not in params) or (params['attempt'] is None):
            raise ValueError("Missing the required parameter `attempt` when calling `complete_quiz_submission_turn_it_in`")
        # verify the required parameter 'validation_token' is set
        if ('validation_token' not in params) or (params['validation_token'] is None):
            raise ValueError("Missing the required parameter `validation_token` when calling `complete_quiz_submission_turn_it_in`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/submissions/{id}/complete'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'attempt' in params:
            form_params.append(('attempt', params['attempt']))
        if 'validation_token' in params:
            form_params.append(('validation_token', params['validation_token']))
        if 'access_code' in params:
            form_params.append(('access_code', params['access_code']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_quiz_submission_start_quiz_taking_session
    def create_quiz_submission_start_quiz_taking_session(self, course_id, quiz_id, **kwargs):
        """
        Create the quiz submission (start a quiz-taking session)
        Start taking a Quiz by creating a QuizSubmission which you can use to answer questions and submit your answers.  <b>Responses</b>  * <b>200 OK</b> if the request was successful * <b>400 Bad Request</b> if the quiz is locked * <b>403 Forbidden</b> if an invalid access code is specified * <b>403 Forbidden</b> if the Quiz's IP filter restriction does not pass * <b>409 Conflict</b> if a QuizSubmission already exists for this user and quiz

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_quiz_submission_start_quiz_taking_session_with_http_info(course_id, quiz_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str access_code: Access code for the Quiz, if any.
        :param bool preview: Whether this should be a preview QuizSubmission and not count towards the user's course record. Teachers only.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'access_code', 'preview']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quiz_submission_start_quiz_taking_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_quiz_submission_start_quiz_taking_session`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `create_quiz_submission_start_quiz_taking_session`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_code' in params:
            form_params.append(('access_code', params['access_code']))
        if 'preview' in params:
            form_params.append(('preview', params['preview']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_quiz_submissions
    def get_all_quiz_submissions(self, course_id, quiz_id, **kwargs):
        """
        Get all quiz submissions.
        Get a list of all submissions for this quiz.  <b>200 OK</b> response code is returned if the request was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_quiz_submissions_with_http_info(course_id, quiz_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param list[str] include: Associations to include with the quiz submission.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_quiz_submissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_all_quiz_submissions`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `get_all_quiz_submissions`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_quiz_submission
    def get_single_quiz_submission(self, course_id, quiz_id, id, **kwargs):
        """
        Get a single quiz submission.
        Get a single quiz submission.  <b>200 OK</b> response code is returned if the request was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_quiz_submission_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: Associations to include with the quiz submission.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_quiz_submission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_quiz_submission`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `get_single_quiz_submission`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_quiz_submission`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/submissions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_student_question_scores_and_comments
    def update_student_question_scores_and_comments(self, course_id, quiz_id, id, attempt, **kwargs):
        """
        Update student question scores and comments.
        Update the amount of points a student has scored for questions they've answered, provide comments for the student about their answer(s), or simply fudge the total score by a specific amount of points.  <b>Responses</b>  * <b>200 OK</b> if the request was successful * <b>403 Forbidden</b> if you are not a teacher in this course * <b>400 Bad Request</b> if the attempt parameter is missing or invalid * <b>400 Bad Request</b> if the specified QS attempt is not yet complete

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_student_question_scores_and_comments_with_http_info(course_id, quiz_id, id, attempt, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str id: ID (required)
        :param int attempt: The attempt number of the quiz submission that should be updated. This attempt MUST be already completed. (required)
        :param Object fudge_points: Amount of positive or negative points to fudge the total score by.
        :param Object questions: A set of scores and comments for each question answered by the student. The keys are the question IDs, and the values are hashes of `score` and `comment` entries. See {Appendix: Manual Scoring} for more on this parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id', 'attempt', 'fudge_points', 'questions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_student_question_scores_and_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_student_question_scores_and_comments`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `update_student_question_scores_and_comments`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_student_question_scores_and_comments`")
        # verify the required parameter 'attempt' is set
        if ('attempt' not in params) or (params['attempt'] is None):
            raise ValueError("Missing the required parameter `attempt` when calling `update_student_question_scores_and_comments`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/submissions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'attempt' in params:
            form_params.append(('attempt', params['attempt']))
        if 'fudge_points' in params:
            form_params.append(('fudge_points', params['fudge_points']))
        if 'questions' in params:
            form_params.append(('questions', params['questions']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
