# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizReport(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, quiz_id=None, report_type=None, readable_type=None, includes_all_versions=None, anonymous=None, generatable=None, created_at=None, updated_at=None, url=None, file=None, progress_url=None, progress=None):
        """
        QuizReport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'quiz_id': 'int',
            'report_type': 'str',
            'readable_type': 'str',
            'includes_all_versions': 'bool',
            'anonymous': 'bool',
            'generatable': 'bool',
            'created_at': 'Datetime',
            'updated_at': 'Datetime',
            'url': 'str',
            'file': 'File',
            'progress_url': 'str',
            'progress': 'Progress'
        }

        self.attribute_map = {
            'id': 'id',
            'quiz_id': 'quiz_id',
            'report_type': 'report_type',
            'readable_type': 'readable_type',
            'includes_all_versions': 'includes_all_versions',
            'anonymous': 'anonymous',
            'generatable': 'generatable',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'url': 'url',
            'file': 'file',
            'progress_url': 'progress_url',
            'progress': 'progress'
        }

        self._id = id
        self._quiz_id = quiz_id
        self._report_type = report_type
        self._readable_type = readable_type
        self._includes_all_versions = includes_all_versions
        self._anonymous = anonymous
        self._generatable = generatable
        self._created_at = created_at
        self._updated_at = updated_at
        self._url = url
        self._file = file
        self._progress_url = progress_url
        self._progress = progress

    @property
    def id(self):
        """
        Gets the id of this QuizReport.
        the ID of the quiz report

        :return: The id of this QuizReport.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizReport.
        the ID of the quiz report

        :param id: The id of this QuizReport.
        :type: int
        """

        self._id = id

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizReport.
        the ID of the quiz

        :return: The quiz_id of this QuizReport.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizReport.
        the ID of the quiz

        :param quiz_id: The quiz_id of this QuizReport.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def report_type(self):
        """
        Gets the report_type of this QuizReport.
        which type of report this is possible values: 'student_analysis', 'item_analysis'

        :return: The report_type of this QuizReport.
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """
        Sets the report_type of this QuizReport.
        which type of report this is possible values: 'student_analysis', 'item_analysis'

        :param report_type: The report_type of this QuizReport.
        :type: str
        """

        self._report_type = report_type

    @property
    def readable_type(self):
        """
        Gets the readable_type of this QuizReport.
        a human-readable (and localized) version of the report_type

        :return: The readable_type of this QuizReport.
        :rtype: str
        """
        return self._readable_type

    @readable_type.setter
    def readable_type(self, readable_type):
        """
        Sets the readable_type of this QuizReport.
        a human-readable (and localized) version of the report_type

        :param readable_type: The readable_type of this QuizReport.
        :type: str
        """

        self._readable_type = readable_type

    @property
    def includes_all_versions(self):
        """
        Gets the includes_all_versions of this QuizReport.
        boolean indicating whether the report represents all submissions or only the most recent ones for each student

        :return: The includes_all_versions of this QuizReport.
        :rtype: bool
        """
        return self._includes_all_versions

    @includes_all_versions.setter
    def includes_all_versions(self, includes_all_versions):
        """
        Sets the includes_all_versions of this QuizReport.
        boolean indicating whether the report represents all submissions or only the most recent ones for each student

        :param includes_all_versions: The includes_all_versions of this QuizReport.
        :type: bool
        """

        self._includes_all_versions = includes_all_versions

    @property
    def anonymous(self):
        """
        Gets the anonymous of this QuizReport.
        boolean indicating whether the report is for an anonymous survey. if true, no student names will be included in the csv

        :return: The anonymous of this QuizReport.
        :rtype: bool
        """
        return self._anonymous

    @anonymous.setter
    def anonymous(self, anonymous):
        """
        Sets the anonymous of this QuizReport.
        boolean indicating whether the report is for an anonymous survey. if true, no student names will be included in the csv

        :param anonymous: The anonymous of this QuizReport.
        :type: bool
        """

        self._anonymous = anonymous

    @property
    def generatable(self):
        """
        Gets the generatable of this QuizReport.
        boolean indicating whether the report can be generated, which is true unless the quiz is a survey one

        :return: The generatable of this QuizReport.
        :rtype: bool
        """
        return self._generatable

    @generatable.setter
    def generatable(self, generatable):
        """
        Sets the generatable of this QuizReport.
        boolean indicating whether the report can be generated, which is true unless the quiz is a survey one

        :param generatable: The generatable of this QuizReport.
        :type: bool
        """

        self._generatable = generatable

    @property
    def created_at(self):
        """
        Gets the created_at of this QuizReport.
        when the report was created

        :return: The created_at of this QuizReport.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this QuizReport.
        when the report was created

        :param created_at: The created_at of this QuizReport.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this QuizReport.
        when the report was last updated

        :return: The updated_at of this QuizReport.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this QuizReport.
        when the report was last updated

        :param updated_at: The updated_at of this QuizReport.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def url(self):
        """
        Gets the url of this QuizReport.
        the API endpoint for this report

        :return: The url of this QuizReport.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this QuizReport.
        the API endpoint for this report

        :param url: The url of this QuizReport.
        :type: str
        """

        self._url = url

    @property
    def file(self):
        """
        Gets the file of this QuizReport.
        if the report has finished generating, a File object that represents it. refer to the Files API for more information about the format

        :return: The file of this QuizReport.
        :rtype: File
        """
        return self._file

    @file.setter
    def file(self, file):
        """
        Sets the file of this QuizReport.
        if the report has finished generating, a File object that represents it. refer to the Files API for more information about the format

        :param file: The file of this QuizReport.
        :type: File
        """

        self._file = file

    @property
    def progress_url(self):
        """
        Gets the progress_url of this QuizReport.
        if the report has not yet finished generating, a URL where information about its progress can be retrieved. refer to the Progress API for more information (Note: not available in JSON-API format)

        :return: The progress_url of this QuizReport.
        :rtype: str
        """
        return self._progress_url

    @progress_url.setter
    def progress_url(self, progress_url):
        """
        Sets the progress_url of this QuizReport.
        if the report has not yet finished generating, a URL where information about its progress can be retrieved. refer to the Progress API for more information (Note: not available in JSON-API format)

        :param progress_url: The progress_url of this QuizReport.
        :type: str
        """

        self._progress_url = progress_url

    @property
    def progress(self):
        """
        Gets the progress of this QuizReport.
        if the report is being generated, a Progress object that represents the operation. Refer to the Progress API for more information about the format. (Note: available only in JSON-API format)

        :return: The progress of this QuizReport.
        :rtype: Progress
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this QuizReport.
        if the report is being generated, a Progress object that represents the operation. Refer to the Progress API for more information about the format. (Note: available only in JSON-API format)

        :param progress: The progress of this QuizReport.
        :type: Progress
        """

        self._progress = progress

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
