# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizAssignmentOverrideSet(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, quiz_id=None, due_dates=None, all_dates=None):
        """
        QuizAssignmentOverrideSet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'quiz_id': 'str',
            'due_dates': 'QuizAssignmentOverride',
            'all_dates': 'QuizAssignmentOverride'
        }

        self.attribute_map = {
            'quiz_id': 'quiz_id',
            'due_dates': 'due_dates',
            'all_dates': 'all_dates'
        }

        self._quiz_id = quiz_id
        self._due_dates = due_dates
        self._all_dates = all_dates

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizAssignmentOverrideSet.
        ID of the quiz those dates are for.

        :return: The quiz_id of this QuizAssignmentOverrideSet.
        :rtype: str
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizAssignmentOverrideSet.
        ID of the quiz those dates are for.

        :param quiz_id: The quiz_id of this QuizAssignmentOverrideSet.
        :type: str
        """

        self._quiz_id = quiz_id

    @property
    def due_dates(self):
        """
        Gets the due_dates of this QuizAssignmentOverrideSet.
        An array of quiz assignment overrides. For students, this array will always contain a single item which is the set of dates that apply to that student. For teachers and staff, it may contain more.

        :return: The due_dates of this QuizAssignmentOverrideSet.
        :rtype: QuizAssignmentOverride
        """
        return self._due_dates

    @due_dates.setter
    def due_dates(self, due_dates):
        """
        Sets the due_dates of this QuizAssignmentOverrideSet.
        An array of quiz assignment overrides. For students, this array will always contain a single item which is the set of dates that apply to that student. For teachers and staff, it may contain more.

        :param due_dates: The due_dates of this QuizAssignmentOverrideSet.
        :type: QuizAssignmentOverride
        """

        self._due_dates = due_dates

    @property
    def all_dates(self):
        """
        Gets the all_dates of this QuizAssignmentOverrideSet.
        An array of all assignment overrides active for the quiz. This is visible only to teachers and staff.

        :return: The all_dates of this QuizAssignmentOverrideSet.
        :rtype: QuizAssignmentOverride
        """
        return self._all_dates

    @all_dates.setter
    def all_dates(self, all_dates):
        """
        Sets the all_dates of this QuizAssignmentOverrideSet.
        An array of all assignment overrides active for the quiz. This is visible only to teachers and staff.

        :param all_dates: The all_dates of this QuizAssignmentOverrideSet.
        :type: QuizAssignmentOverride
        """

        self._all_dates = all_dates

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
