# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Poll(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, question=None, description=None, created_at=None, user_id=None, total_results=None):
        """
        Poll - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'question': 'str',
            'description': 'str',
            'created_at': 'datetime',
            'user_id': 'int',
            'total_results': 'object'
        }

        self.attribute_map = {
            'id': 'id',
            'question': 'question',
            'description': 'description',
            'created_at': 'created_at',
            'user_id': 'user_id',
            'total_results': 'total_results'
        }

        self._id = id
        self._question = question
        self._description = description
        self._created_at = created_at
        self._user_id = user_id
        self._total_results = total_results

    @property
    def id(self):
        """
        Gets the id of this Poll.
        The unique identifier for the poll.

        :return: The id of this Poll.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Poll.
        The unique identifier for the poll.

        :param id: The id of this Poll.
        :type: int
        """

        self._id = id

    @property
    def question(self):
        """
        Gets the question of this Poll.
        The question/title of the poll.

        :return: The question of this Poll.
        :rtype: str
        """
        return self._question

    @question.setter
    def question(self, question):
        """
        Sets the question of this Poll.
        The question/title of the poll.

        :param question: The question of this Poll.
        :type: str
        """

        self._question = question

    @property
    def description(self):
        """
        Gets the description of this Poll.
        A short description of the poll.

        :return: The description of this Poll.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Poll.
        A short description of the poll.

        :param description: The description of this Poll.
        :type: str
        """

        self._description = description

    @property
    def created_at(self):
        """
        Gets the created_at of this Poll.
        The time at which the poll was created.

        :return: The created_at of this Poll.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this Poll.
        The time at which the poll was created.

        :param created_at: The created_at of this Poll.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def user_id(self):
        """
        Gets the user_id of this Poll.
        The unique identifier for the user that created the poll.

        :return: The user_id of this Poll.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Poll.
        The unique identifier for the user that created the poll.

        :param user_id: The user_id of this Poll.
        :type: int
        """

        self._user_id = user_id

    @property
    def total_results(self):
        """
        Gets the total_results of this Poll.
        An aggregate of the results of all associated poll sessions, with the poll choice id as the key, and the aggregated submission count as the value.

        :return: The total_results of this Poll.
        :rtype: object
        """
        return self._total_results

    @total_results.setter
    def total_results(self, total_results):
        """
        Sets the total_results of this Poll.
        An aggregate of the results of all associated poll sessions, with the poll choice id as the key, and the aggregated submission count as the value.

        :param total_results: The total_results of this Poll.
        :type: object
        """

        self._total_results = total_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
