# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class PageRevision(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, revision_id=None, updated_at=None, latest=None, edited_by=None, url=None, title=None, body=None):
        """
        PageRevision - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'revision_id': 'int',
            'updated_at': 'Datetime',
            'latest': 'bool',
            'edited_by': 'User',
            'url': 'str',
            'title': 'str',
            'body': 'str'
        }

        self.attribute_map = {
            'revision_id': 'revision_id',
            'updated_at': 'updated_at',
            'latest': 'latest',
            'edited_by': 'edited_by',
            'url': 'url',
            'title': 'title',
            'body': 'body'
        }

        self._revision_id = revision_id
        self._updated_at = updated_at
        self._latest = latest
        self._edited_by = edited_by
        self._url = url
        self._title = title
        self._body = body

    @property
    def revision_id(self):
        """
        Gets the revision_id of this PageRevision.
        an identifier for this revision of the page

        :return: The revision_id of this PageRevision.
        :rtype: int
        """
        return self._revision_id

    @revision_id.setter
    def revision_id(self, revision_id):
        """
        Sets the revision_id of this PageRevision.
        an identifier for this revision of the page

        :param revision_id: The revision_id of this PageRevision.
        :type: int
        """

        self._revision_id = revision_id

    @property
    def updated_at(self):
        """
        Gets the updated_at of this PageRevision.
        the time when this revision was saved

        :return: The updated_at of this PageRevision.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this PageRevision.
        the time when this revision was saved

        :param updated_at: The updated_at of this PageRevision.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def latest(self):
        """
        Gets the latest of this PageRevision.
        whether this is the latest revision or not

        :return: The latest of this PageRevision.
        :rtype: bool
        """
        return self._latest

    @latest.setter
    def latest(self, latest):
        """
        Sets the latest of this PageRevision.
        whether this is the latest revision or not

        :param latest: The latest of this PageRevision.
        :type: bool
        """

        self._latest = latest

    @property
    def edited_by(self):
        """
        Gets the edited_by of this PageRevision.
        the User who saved this revision, if applicable (this may not be present if the page was imported from another system)

        :return: The edited_by of this PageRevision.
        :rtype: User
        """
        return self._edited_by

    @edited_by.setter
    def edited_by(self, edited_by):
        """
        Sets the edited_by of this PageRevision.
        the User who saved this revision, if applicable (this may not be present if the page was imported from another system)

        :param edited_by: The edited_by of this PageRevision.
        :type: User
        """

        self._edited_by = edited_by

    @property
    def url(self):
        """
        Gets the url of this PageRevision.
        the following fields are not included in the index action and may be omitted from the show action via summary=1 the historic url of the page

        :return: The url of this PageRevision.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this PageRevision.
        the following fields are not included in the index action and may be omitted from the show action via summary=1 the historic url of the page

        :param url: The url of this PageRevision.
        :type: str
        """

        self._url = url

    @property
    def title(self):
        """
        Gets the title of this PageRevision.
        the historic page title

        :return: The title of this PageRevision.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this PageRevision.
        the historic page title

        :param title: The title of this PageRevision.
        :type: str
        """

        self._title = title

    @property
    def body(self):
        """
        Gets the body of this PageRevision.
        the historic page contents

        :return: The body of this PageRevision.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this PageRevision.
        the historic page contents

        :param body: The body of this PageRevision.
        :type: str
        """

        self._body = body

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
