# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Outcome(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, url=None, context_id=None, context_type=None, title=None, display_name=None, description=None, vendor_guid=None, points_possible=None, mastery_points=None, calculation_method=None, calculation_int=None, ratings=None, can_edit=None, assessed=None):
        """
        Outcome - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'url': 'str',
            'context_id': 'int',
            'context_type': 'str',
            'title': 'str',
            'display_name': 'str',
            'description': 'str',
            'vendor_guid': 'str',
            'points_possible': 'int',
            'mastery_points': 'int',
            'calculation_method': 'str',
            'calculation_int': 'int',
            'ratings': 'list[RubricRating]',
            'can_edit': 'bool',
            'assessed': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'url': 'url',
            'context_id': 'context_id',
            'context_type': 'context_type',
            'title': 'title',
            'display_name': 'display_name',
            'description': 'description',
            'vendor_guid': 'vendor_guid',
            'points_possible': 'points_possible',
            'mastery_points': 'mastery_points',
            'calculation_method': 'calculation_method',
            'calculation_int': 'calculation_int',
            'ratings': 'ratings',
            'can_edit': 'can_edit',
            'assessed': 'assessed'
        }

        self._id = id
        self._url = url
        self._context_id = context_id
        self._context_type = context_type
        self._title = title
        self._display_name = display_name
        self._description = description
        self._vendor_guid = vendor_guid
        self._points_possible = points_possible
        self._mastery_points = mastery_points
        self._calculation_method = calculation_method
        self._calculation_int = calculation_int
        self._ratings = ratings
        self._can_edit = can_edit
        self._assessed = assessed

    @property
    def id(self):
        """
        Gets the id of this Outcome.
        the ID of the outcome

        :return: The id of this Outcome.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Outcome.
        the ID of the outcome

        :param id: The id of this Outcome.
        :type: int
        """

        self._id = id

    @property
    def url(self):
        """
        Gets the url of this Outcome.
        the URL for fetching/updating the outcome. should be treated as opaque

        :return: The url of this Outcome.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Outcome.
        the URL for fetching/updating the outcome. should be treated as opaque

        :param url: The url of this Outcome.
        :type: str
        """

        self._url = url

    @property
    def context_id(self):
        """
        Gets the context_id of this Outcome.
        the context owning the outcome. may be null for global outcomes

        :return: The context_id of this Outcome.
        :rtype: int
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id):
        """
        Sets the context_id of this Outcome.
        the context owning the outcome. may be null for global outcomes

        :param context_id: The context_id of this Outcome.
        :type: int
        """

        self._context_id = context_id

    @property
    def context_type(self):
        """
        Gets the context_type of this Outcome.


        :return: The context_type of this Outcome.
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type):
        """
        Sets the context_type of this Outcome.


        :param context_type: The context_type of this Outcome.
        :type: str
        """

        self._context_type = context_type

    @property
    def title(self):
        """
        Gets the title of this Outcome.
        title of the outcome

        :return: The title of this Outcome.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Outcome.
        title of the outcome

        :param title: The title of this Outcome.
        :type: str
        """

        self._title = title

    @property
    def display_name(self):
        """
        Gets the display_name of this Outcome.
        Optional friendly name for reporting

        :return: The display_name of this Outcome.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Outcome.
        Optional friendly name for reporting

        :param display_name: The display_name of this Outcome.
        :type: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Outcome.
        description of the outcome. omitted in the abbreviated form.

        :return: The description of this Outcome.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Outcome.
        description of the outcome. omitted in the abbreviated form.

        :param description: The description of this Outcome.
        :type: str
        """

        self._description = description

    @property
    def vendor_guid(self):
        """
        Gets the vendor_guid of this Outcome.
        A custom GUID for the learning standard.

        :return: The vendor_guid of this Outcome.
        :rtype: str
        """
        return self._vendor_guid

    @vendor_guid.setter
    def vendor_guid(self, vendor_guid):
        """
        Sets the vendor_guid of this Outcome.
        A custom GUID for the learning standard.

        :param vendor_guid: The vendor_guid of this Outcome.
        :type: str
        """

        self._vendor_guid = vendor_guid

    @property
    def points_possible(self):
        """
        Gets the points_possible of this Outcome.
        maximum points possible. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :return: The points_possible of this Outcome.
        :rtype: int
        """
        return self._points_possible

    @points_possible.setter
    def points_possible(self, points_possible):
        """
        Sets the points_possible of this Outcome.
        maximum points possible. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :param points_possible: The points_possible of this Outcome.
        :type: int
        """

        self._points_possible = points_possible

    @property
    def mastery_points(self):
        """
        Gets the mastery_points of this Outcome.
        points necessary to demonstrate mastery outcomes. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :return: The mastery_points of this Outcome.
        :rtype: int
        """
        return self._mastery_points

    @mastery_points.setter
    def mastery_points(self, mastery_points):
        """
        Sets the mastery_points of this Outcome.
        points necessary to demonstrate mastery outcomes. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :param mastery_points: The mastery_points of this Outcome.
        :type: int
        """

        self._mastery_points = mastery_points

    @property
    def calculation_method(self):
        """
        Gets the calculation_method of this Outcome.
        the method used to calculate a students score

        :return: The calculation_method of this Outcome.
        :rtype: str
        """
        return self._calculation_method

    @calculation_method.setter
    def calculation_method(self, calculation_method):
        """
        Sets the calculation_method of this Outcome.
        the method used to calculate a students score

        :param calculation_method: The calculation_method of this Outcome.
        :type: str
        """

        self._calculation_method = calculation_method

    @property
    def calculation_int(self):
        """
        Gets the calculation_int of this Outcome.
        this defines the variable value used by the calculation_method. included only if calculation_method uses it

        :return: The calculation_int of this Outcome.
        :rtype: int
        """
        return self._calculation_int

    @calculation_int.setter
    def calculation_int(self, calculation_int):
        """
        Sets the calculation_int of this Outcome.
        this defines the variable value used by the calculation_method. included only if calculation_method uses it

        :param calculation_int: The calculation_int of this Outcome.
        :type: int
        """

        self._calculation_int = calculation_int

    @property
    def ratings(self):
        """
        Gets the ratings of this Outcome.
        possible ratings for this outcome. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :return: The ratings of this Outcome.
        :rtype: list[RubricRating]
        """
        return self._ratings

    @ratings.setter
    def ratings(self, ratings):
        """
        Sets the ratings of this Outcome.
        possible ratings for this outcome. included only if the outcome embeds a rubric criterion. omitted in the abbreviated form.

        :param ratings: The ratings of this Outcome.
        :type: list[RubricRating]
        """

        self._ratings = ratings

    @property
    def can_edit(self):
        """
        Gets the can_edit of this Outcome.
        whether the current user can update the outcome

        :return: The can_edit of this Outcome.
        :rtype: bool
        """
        return self._can_edit

    @can_edit.setter
    def can_edit(self, can_edit):
        """
        Sets the can_edit of this Outcome.
        whether the current user can update the outcome

        :param can_edit: The can_edit of this Outcome.
        :type: bool
        """

        self._can_edit = can_edit

    @property
    def assessed(self):
        """
        Gets the assessed of this Outcome.
        whether this outcome has been used to assess a student

        :return: The assessed of this Outcome.
        :rtype: bool
        """
        return self._assessed

    @assessed.setter
    def assessed(self, assessed):
        """
        Sets the assessed of this Outcome.
        whether this outcome has been used to assess a student

        :param assessed: The assessed of this Outcome.
        :type: bool
        """

        self._assessed = assessed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
