# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class GradeChangeEventLinks(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, assignment=None, course=None, student=None, grader=None, page_view=None):
        """
        GradeChangeEventLinks - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'assignment': 'int',
            'course': 'int',
            'student': 'int',
            'grader': 'int',
            'page_view': 'str'
        }

        self.attribute_map = {
            'assignment': 'assignment',
            'course': 'course',
            'student': 'student',
            'grader': 'grader',
            'page_view': 'page_view'
        }

        self._assignment = assignment
        self._course = course
        self._student = student
        self._grader = grader
        self._page_view = page_view

    @property
    def assignment(self):
        """
        Gets the assignment of this GradeChangeEventLinks.
        ID of the assignment associated with the event

        :return: The assignment of this GradeChangeEventLinks.
        :rtype: int
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """
        Sets the assignment of this GradeChangeEventLinks.
        ID of the assignment associated with the event

        :param assignment: The assignment of this GradeChangeEventLinks.
        :type: int
        """

        self._assignment = assignment

    @property
    def course(self):
        """
        Gets the course of this GradeChangeEventLinks.
        ID of the course associated with the event. will match the context_id in the associated assignment if the context type for the assignment is a course

        :return: The course of this GradeChangeEventLinks.
        :rtype: int
        """
        return self._course

    @course.setter
    def course(self, course):
        """
        Sets the course of this GradeChangeEventLinks.
        ID of the course associated with the event. will match the context_id in the associated assignment if the context type for the assignment is a course

        :param course: The course of this GradeChangeEventLinks.
        :type: int
        """

        self._course = course

    @property
    def student(self):
        """
        Gets the student of this GradeChangeEventLinks.
        ID of the student associated with the event. will match the user_id in the associated submission.

        :return: The student of this GradeChangeEventLinks.
        :rtype: int
        """
        return self._student

    @student.setter
    def student(self, student):
        """
        Sets the student of this GradeChangeEventLinks.
        ID of the student associated with the event. will match the user_id in the associated submission.

        :param student: The student of this GradeChangeEventLinks.
        :type: int
        """

        self._student = student

    @property
    def grader(self):
        """
        Gets the grader of this GradeChangeEventLinks.
        ID of the grader associated with the event. will match the grader_id in the associated submission.

        :return: The grader of this GradeChangeEventLinks.
        :rtype: int
        """
        return self._grader

    @grader.setter
    def grader(self, grader):
        """
        Sets the grader of this GradeChangeEventLinks.
        ID of the grader associated with the event. will match the grader_id in the associated submission.

        :param grader: The grader of this GradeChangeEventLinks.
        :type: int
        """

        self._grader = grader

    @property
    def page_view(self):
        """
        Gets the page_view of this GradeChangeEventLinks.
        ID of the page view during the event if it exists.

        :return: The page_view of this GradeChangeEventLinks.
        :rtype: str
        """
        return self._page_view

    @page_view.setter
    def page_view(self, page_view):
        """
        Sets the page_view of this GradeChangeEventLinks.
        ID of the page view during the event if it exists.

        :param page_view: The page_view of this GradeChangeEventLinks.
        :type: str
        """

        self._page_view = page_view

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
