# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Conference(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, conference_type=None, conference_key=None, description=None, duration=None, ended_at=None, started_at=None, title=None, users=None, has_advanced_settings=None, long_running=None, user_settings=None, recordings=None, url=None, join_url=None):
        """
        Conference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'conference_type': 'str',
            'conference_key': 'str',
            'description': 'str',
            'duration': 'int',
            'ended_at': 'Datetime',
            'started_at': 'Datetime',
            'title': 'str',
            'users': 'list[int]',
            'has_advanced_settings': 'bool',
            'long_running': 'bool',
            'user_settings': 'dict',
            'recordings': 'list[ConferenceRecording]',
            'url': 'str',
            'join_url': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'conference_type': 'conference_type',
            'conference_key': 'conference_key',
            'description': 'description',
            'duration': 'duration',
            'ended_at': 'ended_at',
            'started_at': 'started_at',
            'title': 'title',
            'users': 'users',
            'has_advanced_settings': 'has_advanced_settings',
            'long_running': 'long_running',
            'user_settings': 'user_settings',
            'recordings': 'recordings',
            'url': 'url',
            'join_url': 'join_url'
        }

        self._id = id
        self._conference_type = conference_type
        self._conference_key = conference_key
        self._description = description
        self._duration = duration
        self._ended_at = ended_at
        self._started_at = started_at
        self._title = title
        self._users = users
        self._has_advanced_settings = has_advanced_settings
        self._long_running = long_running
        self._user_settings = user_settings
        self._recordings = recordings
        self._url = url
        self._join_url = join_url

    @property
    def id(self):
        """
        Gets the id of this Conference.
        The id of the conference

        :return: The id of this Conference.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Conference.
        The id of the conference

        :param id: The id of this Conference.
        :type: int
        """

        self._id = id

    @property
    def conference_type(self):
        """
        Gets the conference_type of this Conference.
        The type of conference

        :return: The conference_type of this Conference.
        :rtype: str
        """
        return self._conference_type

    @conference_type.setter
    def conference_type(self, conference_type):
        """
        Sets the conference_type of this Conference.
        The type of conference

        :param conference_type: The conference_type of this Conference.
        :type: str
        """

        self._conference_type = conference_type

    @property
    def conference_key(self):
        """
        Gets the conference_key of this Conference.
        The 3rd party's ID for the conference

        :return: The conference_key of this Conference.
        :rtype: str
        """
        return self._conference_key

    @conference_key.setter
    def conference_key(self, conference_key):
        """
        Sets the conference_key of this Conference.
        The 3rd party's ID for the conference

        :param conference_key: The conference_key of this Conference.
        :type: str
        """

        self._conference_key = conference_key

    @property
    def description(self):
        """
        Gets the description of this Conference.
        The description for the conference

        :return: The description of this Conference.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Conference.
        The description for the conference

        :param description: The description of this Conference.
        :type: str
        """

        self._description = description

    @property
    def duration(self):
        """
        Gets the duration of this Conference.
        The expected duration the conference is supposed to last

        :return: The duration of this Conference.
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this Conference.
        The expected duration the conference is supposed to last

        :param duration: The duration of this Conference.
        :type: int
        """

        self._duration = duration

    @property
    def ended_at(self):
        """
        Gets the ended_at of this Conference.
        The date that the conference ended at, null if it hasn't ended

        :return: The ended_at of this Conference.
        :rtype: Datetime
        """
        return self._ended_at

    @ended_at.setter
    def ended_at(self, ended_at):
        """
        Sets the ended_at of this Conference.
        The date that the conference ended at, null if it hasn't ended

        :param ended_at: The ended_at of this Conference.
        :type: Datetime
        """

        self._ended_at = ended_at

    @property
    def started_at(self):
        """
        Gets the started_at of this Conference.
        The date the conference started at, null if it hasn't started

        :return: The started_at of this Conference.
        :rtype: Datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """
        Sets the started_at of this Conference.
        The date the conference started at, null if it hasn't started

        :param started_at: The started_at of this Conference.
        :type: Datetime
        """

        self._started_at = started_at

    @property
    def title(self):
        """
        Gets the title of this Conference.
        The title of the conference

        :return: The title of this Conference.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Conference.
        The title of the conference

        :param title: The title of this Conference.
        :type: str
        """

        self._title = title

    @property
    def users(self):
        """
        Gets the users of this Conference.
        Array of user ids that are participants in the conference

        :return: The users of this Conference.
        :rtype: list[int]
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this Conference.
        Array of user ids that are participants in the conference

        :param users: The users of this Conference.
        :type: list[int]
        """

        self._users = users

    @property
    def has_advanced_settings(self):
        """
        Gets the has_advanced_settings of this Conference.
        True if the conference type has advanced settings.

        :return: The has_advanced_settings of this Conference.
        :rtype: bool
        """
        return self._has_advanced_settings

    @has_advanced_settings.setter
    def has_advanced_settings(self, has_advanced_settings):
        """
        Sets the has_advanced_settings of this Conference.
        True if the conference type has advanced settings.

        :param has_advanced_settings: The has_advanced_settings of this Conference.
        :type: bool
        """

        self._has_advanced_settings = has_advanced_settings

    @property
    def long_running(self):
        """
        Gets the long_running of this Conference.
        If true the conference is long running and has no expected end time

        :return: The long_running of this Conference.
        :rtype: bool
        """
        return self._long_running

    @long_running.setter
    def long_running(self, long_running):
        """
        Sets the long_running of this Conference.
        If true the conference is long running and has no expected end time

        :param long_running: The long_running of this Conference.
        :type: bool
        """

        self._long_running = long_running

    @property
    def user_settings(self):
        """
        Gets the user_settings of this Conference.
        A collection of settings specific to the conference type

        :return: The user_settings of this Conference.
        :rtype: dict
        """
        return self._user_settings

    @user_settings.setter
    def user_settings(self, user_settings):
        """
        Sets the user_settings of this Conference.
        A collection of settings specific to the conference type

        :param user_settings: The user_settings of this Conference.
        :type: dict
        """

        self._user_settings = user_settings

    @property
    def recordings(self):
        """
        Gets the recordings of this Conference.
        A List of recordings for the conference

        :return: The recordings of this Conference.
        :rtype: list[ConferenceRecording]
        """
        return self._recordings

    @recordings.setter
    def recordings(self, recordings):
        """
        Sets the recordings of this Conference.
        A List of recordings for the conference

        :param recordings: The recordings of this Conference.
        :type: list[ConferenceRecording]
        """

        self._recordings = recordings

    @property
    def url(self):
        """
        Gets the url of this Conference.
        URL for the conference, may be null if the conference type doesn't set it

        :return: The url of this Conference.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Conference.
        URL for the conference, may be null if the conference type doesn't set it

        :param url: The url of this Conference.
        :type: str
        """

        self._url = url

    @property
    def join_url(self):
        """
        Gets the join_url of this Conference.
        URL to join the conference, may be null if the conference type doesn't set it

        :return: The join_url of this Conference.
        :rtype: str
        """
        return self._join_url

    @join_url.setter
    def join_url(self, join_url):
        """
        Sets the join_url of this Conference.
        URL to join the conference, may be null if the conference type doesn't set it

        :param join_url: The join_url of this Conference.
        :type: str
        """

        self._join_url = join_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
