# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class CommunicationChannel(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, address=None, type=None, position=None, user_id=None, workflow_state=None):
        """
        CommunicationChannel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'address': 'str',
            'type': 'str',
            'position': 'int',
            'user_id': 'int',
            'workflow_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'address': 'address',
            'type': 'type',
            'position': 'position',
            'user_id': 'user_id',
            'workflow_state': 'workflow_state'
        }

        self._id = id
        self._address = address
        self._type = type
        self._position = position
        self._user_id = user_id
        self._workflow_state = workflow_state

    @property
    def id(self):
        """
        Gets the id of this CommunicationChannel.
        The ID of the communication channel.

        :return: The id of this CommunicationChannel.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CommunicationChannel.
        The ID of the communication channel.

        :param id: The id of this CommunicationChannel.
        :type: int
        """

        self._id = id

    @property
    def address(self):
        """
        Gets the address of this CommunicationChannel.
        The address, or path, of the communication channel.

        :return: The address of this CommunicationChannel.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this CommunicationChannel.
        The address, or path, of the communication channel.

        :param address: The address of this CommunicationChannel.
        :type: str
        """

        self._address = address

    @property
    def type(self):
        """
        Gets the type of this CommunicationChannel.
        The type of communcation channel being described. Possible values are: 'email', 'sms', 'chat', 'facebook', 'twitter' or 'yo'. This field determines the type of value seen in 'address'.

        :return: The type of this CommunicationChannel.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CommunicationChannel.
        The type of communcation channel being described. Possible values are: 'email', 'sms', 'chat', 'facebook', 'twitter' or 'yo'. This field determines the type of value seen in 'address'.

        :param type: The type of this CommunicationChannel.
        :type: str
        """

        self._type = type

    @property
    def position(self):
        """
        Gets the position of this CommunicationChannel.
        The position of this communication channel relative to the user's other channels when they are ordered.

        :return: The position of this CommunicationChannel.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this CommunicationChannel.
        The position of this communication channel relative to the user's other channels when they are ordered.

        :param position: The position of this CommunicationChannel.
        :type: int
        """

        self._position = position

    @property
    def user_id(self):
        """
        Gets the user_id of this CommunicationChannel.
        The ID of the user that owns this communication channel.

        :return: The user_id of this CommunicationChannel.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this CommunicationChannel.
        The ID of the user that owns this communication channel.

        :param user_id: The user_id of this CommunicationChannel.
        :type: int
        """

        self._user_id = user_id

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this CommunicationChannel.
        The current state of the communication channel. Possible values are: 'unconfirmed' or 'active'.

        :return: The workflow_state of this CommunicationChannel.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this CommunicationChannel.
        The current state of the communication channel. Possible values are: 'unconfirmed' or 'active'.

        :param workflow_state: The workflow_state of this CommunicationChannel.
        :type: str
        """

        self._workflow_state = workflow_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
