# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class CalendareventsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_calendar_event
    def create_calendar_event(self, calendar_event_context_code, **kwargs):
        """
        Create a calendar event
        Create and return a new calendar event

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_calendar_event_with_http_info(calendar_event_context_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calendar_event_context_code: Context code of the course/group/user whose calendar this event should be added to. (required)
        :param str calendar_event_title: Short title for the calendar event.
        :param str calendar_event_description: Longer HTML description of the event.
        :param Object calendar_event_start_at: Start date/time of the event.
        :param Object calendar_event_end_at: End date/time of the event.
        :param str calendar_event_location_name: Location name of the event.
        :param str calendar_event_location_address: Location address
        :param str calendar_event_time_zone_edited: Time zone of the user editing the event. Allowed time zones are {http://www.iana.org/time-zones IANA time zones} or friendlier {http://api.rubyonrails.org/classes/ActiveSupport/TimeZone.html Ruby on Rails time zones}.
        :param Object calendar_event_child_event_data_x_start_at: Section-level start time(s) if this is a course event. X can be any identifier, provided that it is consistent across the start_at, end_at and context_code
        :param Object calendar_event_child_event_data_x_end_at: Section-level end time(s) if this is a course event.
        :param str calendar_event_child_event_data_x_context_code: Context code(s) corresponding to the section-level start and end time(s).
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calendar_event_context_code', 'calendar_event_title', 'calendar_event_description', 'calendar_event_start_at', 'calendar_event_end_at', 'calendar_event_location_name', 'calendar_event_location_address', 'calendar_event_time_zone_edited', 'calendar_event_child_event_data_x_start_at', 'calendar_event_child_event_data_x_end_at', 'calendar_event_child_event_data_x_context_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_calendar_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'calendar_event_context_code' is set
        if ('calendar_event_context_code' not in params) or (params['calendar_event_context_code'] is None):
            raise ValueError("Missing the required parameter `calendar_event_context_code` when calling `create_calendar_event`")

        resource_path = '/v1/calendar_events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'calendar_event_context_code' in params:
            form_params.append(('calendar_event[context_code]', params['calendar_event_context_code']))
        if 'calendar_event_title' in params:
            form_params.append(('calendar_event[title]', params['calendar_event_title']))
        if 'calendar_event_description' in params:
            form_params.append(('calendar_event[description]', params['calendar_event_description']))
        if 'calendar_event_start_at' in params:
            form_params.append(('calendar_event[start_at]', params['calendar_event_start_at']))
        if 'calendar_event_end_at' in params:
            form_params.append(('calendar_event[end_at]', params['calendar_event_end_at']))
        if 'calendar_event_location_name' in params:
            form_params.append(('calendar_event[location_name]', params['calendar_event_location_name']))
        if 'calendar_event_location_address' in params:
            form_params.append(('calendar_event[location_address]', params['calendar_event_location_address']))
        if 'calendar_event_time_zone_edited' in params:
            form_params.append(('calendar_event[time_zone_edited]', params['calendar_event_time_zone_edited']))
        if 'calendar_event_child_event_data_x_start_at' in params:
            form_params.append(('calendar_event[child_event_data][X][start_at]', params['calendar_event_child_event_data_x_start_at']))
        if 'calendar_event_child_event_data_x_end_at' in params:
            form_params.append(('calendar_event[child_event_data][X][end_at]', params['calendar_event_child_event_data_x_end_at']))
        if 'calendar_event_child_event_data_x_context_code' in params:
            form_params.append(('calendar_event[child_event_data][X][context_code]', params['calendar_event_child_event_data_x_context_code']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_calendar_event
    def delete_calendar_event(self, id, **kwargs):
        """
        Delete a calendar event
        Delete an event from the calendar and return the deleted event

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_calendar_event_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str cancel_reason: Reason for deleting/canceling the event.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'cancel_reason']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calendar_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_calendar_event`")

        resource_path = '/v1/calendar_events/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'cancel_reason' in params:
            query_params['cancel_reason'] = params['cancel_reason']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_calendar_event_or_assignment
    def get_single_calendar_event_or_assignment(self, id, **kwargs):
        """
        Get a single calendar event or assignment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_calendar_event_or_assignment_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: CalendarEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_calendar_event_or_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_calendar_event_or_assignment`")

        resource_path = '/v1/calendar_events/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CalendarEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_calendar_events
    def list_calendar_events(self, **kwargs):
        """
        List calendar events
        Retrieve the list of calendar events or assignments for the current user

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_calendar_events_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: Defaults to \"event\"
        :param Object start_date: Only return events since the start_date (inclusive). Defaults to today. The value should be formatted as: yyyy-mm-dd or ISO 8601 YYYY-MM-DDTHH:MM:SSZ.
        :param Object end_date: Only return events before the end_date (inclusive). Defaults to start_date. The value should be formatted as: yyyy-mm-dd or ISO 8601 YYYY-MM-DDTHH:MM:SSZ. If end_date is the same as start_date, then only events on that day are returned.
        :param bool undated: Defaults to false (dated events only). If true, only return undated events and ignore start_date and end_date.
        :param bool all_events: Defaults to false (uses start_date, end_date, and undated criteria). If true, all events are returned, ignoring start_date, end_date, and undated criteria.
        :param list[str] context_codes: List of context codes of courses/groups/users whose events you want to see. If not specified, defaults to the current user (i.e personal calendar, no course/group events). Limited to 10 context codes, additional ones are ignored. The format of this field is the context type, followed by an underscore, followed by the context id. For example: course_42
        :return: list[CalendarEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'start_date', 'end_date', 'undated', 'all_events', 'context_codes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_calendar_events" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/calendar_events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'start_date' in params:
            query_params['start_date'] = params['start_date']
        if 'end_date' in params:
            query_params['end_date'] = params['end_date']
        if 'undated' in params:
            query_params['undated'] = params['undated']
        if 'all_events' in params:
            query_params['all_events'] = params['all_events']
        if 'context_codes' in params:
            query_params['context_codes'] = params['context_codes']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CalendarEvent]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reserve_time_slot
    def reserve_time_slot(self, id, **kwargs):
        """
        Reserve a time slot
        Reserves a particular time slot and return the new reservation

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reserve_time_slot_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str participant_id: User or group id for whom you are making the reservation (depends on the participant type). Defaults to the current user (or user's candidate group).
        :param bool cancel_existing: Defaults to false. If true, cancel any previous reservation(s) for this participant and appointment group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'participant_id', 'cancel_existing']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reserve_time_slot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `reserve_time_slot`")

        resource_path = '/v1/calendar_events/{id}/reservations'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'participant_id' in params:
            form_params.append(('participant_id', params['participant_id']))
        if 'cancel_existing' in params:
            form_params.append(('cancel_existing', params['cancel_existing']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reserve_time_slot_participant_id
    def reserve_time_slot_participant_id(self, id, participant_id, **kwargs):
        """
        Reserve a time slot
        Reserves a particular time slot and return the new reservation

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reserve_time_slot_participant_id_with_http_info(id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str participant_id: User or group id for whom you are making the reservation (depends on the participant type). Defaults to the current user (or user's candidate group). (required)
        :param bool cancel_existing: Defaults to false. If true, cancel any previous reservation(s) for this participant and appointment group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'participant_id', 'cancel_existing']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reserve_time_slot_participant_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `reserve_time_slot_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `reserve_time_slot_participant_id`")

        resource_path = '/v1/calendar_events/{id}/reservations/{participant_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'participant_id' in params:
            path_params['participant_id'] = params['participant_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'cancel_existing' in params:
            form_params.append(('cancel_existing', params['cancel_existing']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_calendar_event
    def update_calendar_event(self, id, calendar_event_context_code, **kwargs):
        """
        Update a calendar event
        Update and return a calendar event

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_calendar_event_with_http_info(id, calendar_event_context_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str calendar_event_context_code: Context code of the course/group/user whose calendar this event should be added to. (required)
        :param str calendar_event_title: Short title for the calendar event.
        :param str calendar_event_description: Longer HTML description of the event.
        :param Object calendar_event_start_at: Start date/time of the event.
        :param Object calendar_event_end_at: End date/time of the event.
        :param str calendar_event_location_name: Location name of the event.
        :param str calendar_event_location_address: Location address
        :param str calendar_event_time_zone_edited: Time zone of the user editing the event. Allowed time zones are {http://www.iana.org/time-zones IANA time zones} or friendlier {http://api.rubyonrails.org/classes/ActiveSupport/TimeZone.html Ruby on Rails time zones}.
        :param Object calendar_event_child_event_data_x_start_at: Section-level start time(s) if this is a course event. X can be any identifier, provided that it is consistent across the start_at, end_at and context_code
        :param Object calendar_event_child_event_data_x_end_at: Section-level end time(s) if this is a course event.
        :param str calendar_event_child_event_data_x_context_code: Context code(s) corresponding to the section-level start and end time(s).
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'calendar_event_context_code', 'calendar_event_title', 'calendar_event_description', 'calendar_event_start_at', 'calendar_event_end_at', 'calendar_event_location_name', 'calendar_event_location_address', 'calendar_event_time_zone_edited', 'calendar_event_child_event_data_x_start_at', 'calendar_event_child_event_data_x_end_at', 'calendar_event_child_event_data_x_context_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_calendar_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_calendar_event`")
        # verify the required parameter 'calendar_event_context_code' is set
        if ('calendar_event_context_code' not in params) or (params['calendar_event_context_code'] is None):
            raise ValueError("Missing the required parameter `calendar_event_context_code` when calling `update_calendar_event`")

        resource_path = '/v1/calendar_events/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'calendar_event_context_code' in params:
            form_params.append(('calendar_event[context_code]', params['calendar_event_context_code']))
        if 'calendar_event_title' in params:
            form_params.append(('calendar_event[title]', params['calendar_event_title']))
        if 'calendar_event_description' in params:
            form_params.append(('calendar_event[description]', params['calendar_event_description']))
        if 'calendar_event_start_at' in params:
            form_params.append(('calendar_event[start_at]', params['calendar_event_start_at']))
        if 'calendar_event_end_at' in params:
            form_params.append(('calendar_event[end_at]', params['calendar_event_end_at']))
        if 'calendar_event_location_name' in params:
            form_params.append(('calendar_event[location_name]', params['calendar_event_location_name']))
        if 'calendar_event_location_address' in params:
            form_params.append(('calendar_event[location_address]', params['calendar_event_location_address']))
        if 'calendar_event_time_zone_edited' in params:
            form_params.append(('calendar_event[time_zone_edited]', params['calendar_event_time_zone_edited']))
        if 'calendar_event_child_event_data_x_start_at' in params:
            form_params.append(('calendar_event[child_event_data][X][start_at]', params['calendar_event_child_event_data_x_start_at']))
        if 'calendar_event_child_event_data_x_end_at' in params:
            form_params.append(('calendar_event[child_event_data][X][end_at]', params['calendar_event_child_event_data_x_end_at']))
        if 'calendar_event_child_event_data_x_context_code' in params:
            form_params.append(('calendar_event[child_event_data][X][context_code]', params['calendar_event_child_event_data_x_context_code']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
