# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class RubricCriteria(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, points=None, id=None, outcome_id=None, vendor_guid=None, description=None, long_description=None, ratings=None):
        """
        RubricCriteria - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'points': 'int',
            'id': 'str',
            'outcome_id': 'str',
            'vendor_guid': 'str',
            'description': 'str',
            'long_description': 'str',
            'ratings': 'list[RubricRating]'
        }

        self.attribute_map = {
            'points': 'points',
            'id': 'id',
            'outcome_id': 'outcome_id',
            'vendor_guid': 'vendor_guid',
            'description': 'description',
            'long_description': 'long_description',
            'ratings': 'ratings'
        }

        self._points = points
        self._id = id
        self._outcome_id = outcome_id
        self._vendor_guid = vendor_guid
        self._description = description
        self._long_description = long_description
        self._ratings = ratings

    @property
    def points(self):
        """
        Gets the points of this RubricCriteria.


        :return: The points of this RubricCriteria.
        :rtype: int
        """
        return self._points

    @points.setter
    def points(self, points):
        """
        Sets the points of this RubricCriteria.


        :param points: The points of this RubricCriteria.
        :type: int
        """

        self._points = points

    @property
    def id(self):
        """
        Gets the id of this RubricCriteria.
        The id of rubric criteria.

        :return: The id of this RubricCriteria.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RubricCriteria.
        The id of rubric criteria.

        :param id: The id of this RubricCriteria.
        :type: str
        """

        self._id = id

    @property
    def outcome_id(self):
        """
        Gets the outcome_id of this RubricCriteria.
        (Optional) The id of the learning outcome this criteria uses, if any.

        :return: The outcome_id of this RubricCriteria.
        :rtype: str
        """
        return self._outcome_id

    @outcome_id.setter
    def outcome_id(self, outcome_id):
        """
        Sets the outcome_id of this RubricCriteria.
        (Optional) The id of the learning outcome this criteria uses, if any.

        :param outcome_id: The outcome_id of this RubricCriteria.
        :type: str
        """

        self._outcome_id = outcome_id

    @property
    def vendor_guid(self):
        """
        Gets the vendor_guid of this RubricCriteria.
        (Optional) The 3rd party vendor's GUID for the outcome this criteria references, if any.

        :return: The vendor_guid of this RubricCriteria.
        :rtype: str
        """
        return self._vendor_guid

    @vendor_guid.setter
    def vendor_guid(self, vendor_guid):
        """
        Sets the vendor_guid of this RubricCriteria.
        (Optional) The 3rd party vendor's GUID for the outcome this criteria references, if any.

        :param vendor_guid: The vendor_guid of this RubricCriteria.
        :type: str
        """

        self._vendor_guid = vendor_guid

    @property
    def description(self):
        """
        Gets the description of this RubricCriteria.


        :return: The description of this RubricCriteria.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this RubricCriteria.


        :param description: The description of this RubricCriteria.
        :type: str
        """

        self._description = description

    @property
    def long_description(self):
        """
        Gets the long_description of this RubricCriteria.


        :return: The long_description of this RubricCriteria.
        :rtype: str
        """
        return self._long_description

    @long_description.setter
    def long_description(self, long_description):
        """
        Sets the long_description of this RubricCriteria.


        :param long_description: The long_description of this RubricCriteria.
        :type: str
        """

        self._long_description = long_description

    @property
    def ratings(self):
        """
        Gets the ratings of this RubricCriteria.


        :return: The ratings of this RubricCriteria.
        :rtype: list[RubricRating]
        """
        return self._ratings

    @ratings.setter
    def ratings(self, ratings):
        """
        Sets the ratings of this RubricCriteria.


        :param ratings: The ratings of this RubricCriteria.
        :type: list[RubricRating]
        """

        self._ratings = ratings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
