# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class AppointmentGroup(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, title=None, start_at=None, end_at=None, description=None, location_name=None, location_address=None, participant_count=None, reserved_times=None, context_codes=None, sub_context_codes=None, workflow_state=None, requiring_action=None, appointments_count=None, appointments=None, new_appointments=None, max_appointments_per_participant=None, min_appointments_per_participant=None, participants_per_appointment=None, participant_visibility=None, participant_type=None, url=None, html_url=None, created_at=None, updated_at=None):
        """
        AppointmentGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'title': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'description': 'str',
            'location_name': 'str',
            'location_address': 'str',
            'participant_count': 'int',
            'reserved_times': 'list[Appointment]',
            'context_codes': 'list[str]',
            'sub_context_codes': 'list[int]',
            'workflow_state': 'str',
            'requiring_action': 'bool',
            'appointments_count': 'int',
            'appointments': 'list[CalendarEvent]',
            'new_appointments': 'list[CalendarEvent]',
            'max_appointments_per_participant': 'int',
            'min_appointments_per_participant': 'int',
            'participants_per_appointment': 'int',
            'participant_visibility': 'str',
            'participant_type': 'str',
            'url': 'str',
            'html_url': 'str',
            'created_at': 'Datetime',
            'updated_at': 'Datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'description': 'description',
            'location_name': 'location_name',
            'location_address': 'location_address',
            'participant_count': 'participant_count',
            'reserved_times': 'reserved_times',
            'context_codes': 'context_codes',
            'sub_context_codes': 'sub_context_codes',
            'workflow_state': 'workflow_state',
            'requiring_action': 'requiring_action',
            'appointments_count': 'appointments_count',
            'appointments': 'appointments',
            'new_appointments': 'new_appointments',
            'max_appointments_per_participant': 'max_appointments_per_participant',
            'min_appointments_per_participant': 'min_appointments_per_participant',
            'participants_per_appointment': 'participants_per_appointment',
            'participant_visibility': 'participant_visibility',
            'participant_type': 'participant_type',
            'url': 'url',
            'html_url': 'html_url',
            'created_at': 'created_at',
            'updated_at': 'updated_at'
        }

        self._id = id
        self._title = title
        self._start_at = start_at
        self._end_at = end_at
        self._description = description
        self._location_name = location_name
        self._location_address = location_address
        self._participant_count = participant_count
        self._reserved_times = reserved_times
        self._context_codes = context_codes
        self._sub_context_codes = sub_context_codes
        self._workflow_state = workflow_state
        self._requiring_action = requiring_action
        self._appointments_count = appointments_count
        self._appointments = appointments
        self._new_appointments = new_appointments
        self._max_appointments_per_participant = max_appointments_per_participant
        self._min_appointments_per_participant = min_appointments_per_participant
        self._participants_per_appointment = participants_per_appointment
        self._participant_visibility = participant_visibility
        self._participant_type = participant_type
        self._url = url
        self._html_url = html_url
        self._created_at = created_at
        self._updated_at = updated_at

    @property
    def id(self):
        """
        Gets the id of this AppointmentGroup.
        The ID of the appointment group

        :return: The id of this AppointmentGroup.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AppointmentGroup.
        The ID of the appointment group

        :param id: The id of this AppointmentGroup.
        :type: int
        """

        self._id = id

    @property
    def title(self):
        """
        Gets the title of this AppointmentGroup.
        The title of the appointment group

        :return: The title of this AppointmentGroup.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this AppointmentGroup.
        The title of the appointment group

        :param title: The title of this AppointmentGroup.
        :type: str
        """

        self._title = title

    @property
    def start_at(self):
        """
        Gets the start_at of this AppointmentGroup.
        The start of the first time slot in the appointment group

        :return: The start_at of this AppointmentGroup.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this AppointmentGroup.
        The start of the first time slot in the appointment group

        :param start_at: The start_at of this AppointmentGroup.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this AppointmentGroup.
        The end of the last time slot in the appointment group

        :return: The end_at of this AppointmentGroup.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this AppointmentGroup.
        The end of the last time slot in the appointment group

        :param end_at: The end_at of this AppointmentGroup.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def description(self):
        """
        Gets the description of this AppointmentGroup.
        The text description of the appointment group

        :return: The description of this AppointmentGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AppointmentGroup.
        The text description of the appointment group

        :param description: The description of this AppointmentGroup.
        :type: str
        """

        self._description = description

    @property
    def location_name(self):
        """
        Gets the location_name of this AppointmentGroup.
        The location name of the appointment group

        :return: The location_name of this AppointmentGroup.
        :rtype: str
        """
        return self._location_name

    @location_name.setter
    def location_name(self, location_name):
        """
        Sets the location_name of this AppointmentGroup.
        The location name of the appointment group

        :param location_name: The location_name of this AppointmentGroup.
        :type: str
        """

        self._location_name = location_name

    @property
    def location_address(self):
        """
        Gets the location_address of this AppointmentGroup.
        The address of the appointment group's location

        :return: The location_address of this AppointmentGroup.
        :rtype: str
        """
        return self._location_address

    @location_address.setter
    def location_address(self, location_address):
        """
        Sets the location_address of this AppointmentGroup.
        The address of the appointment group's location

        :param location_address: The location_address of this AppointmentGroup.
        :type: str
        """

        self._location_address = location_address

    @property
    def participant_count(self):
        """
        Gets the participant_count of this AppointmentGroup.
        The number of participant who have reserved slots (see include[] argument)

        :return: The participant_count of this AppointmentGroup.
        :rtype: int
        """
        return self._participant_count

    @participant_count.setter
    def participant_count(self, participant_count):
        """
        Sets the participant_count of this AppointmentGroup.
        The number of participant who have reserved slots (see include[] argument)

        :param participant_count: The participant_count of this AppointmentGroup.
        :type: int
        """

        self._participant_count = participant_count

    @property
    def reserved_times(self):
        """
        Gets the reserved_times of this AppointmentGroup.
        The start and end times of slots reserved by the current user as well as the id of the calendar event for the reservation (see include[] argument)

        :return: The reserved_times of this AppointmentGroup.
        :rtype: list[Appointment]
        """
        return self._reserved_times

    @reserved_times.setter
    def reserved_times(self, reserved_times):
        """
        Sets the reserved_times of this AppointmentGroup.
        The start and end times of slots reserved by the current user as well as the id of the calendar event for the reservation (see include[] argument)

        :param reserved_times: The reserved_times of this AppointmentGroup.
        :type: list[Appointment]
        """

        self._reserved_times = reserved_times

    @property
    def context_codes(self):
        """
        Gets the context_codes of this AppointmentGroup.
        The context codes (i.e. courses) this appointment group belongs to. Only people in these courses will be eligible to sign up.

        :return: The context_codes of this AppointmentGroup.
        :rtype: list[str]
        """
        return self._context_codes

    @context_codes.setter
    def context_codes(self, context_codes):
        """
        Sets the context_codes of this AppointmentGroup.
        The context codes (i.e. courses) this appointment group belongs to. Only people in these courses will be eligible to sign up.

        :param context_codes: The context_codes of this AppointmentGroup.
        :type: list[str]
        """

        self._context_codes = context_codes

    @property
    def sub_context_codes(self):
        """
        Gets the sub_context_codes of this AppointmentGroup.
        The sub-context codes (i.e. course sections and group categories) this appointment group is restricted to

        :return: The sub_context_codes of this AppointmentGroup.
        :rtype: list[int]
        """
        return self._sub_context_codes

    @sub_context_codes.setter
    def sub_context_codes(self, sub_context_codes):
        """
        Sets the sub_context_codes of this AppointmentGroup.
        The sub-context codes (i.e. course sections and group categories) this appointment group is restricted to

        :param sub_context_codes: The sub_context_codes of this AppointmentGroup.
        :type: list[int]
        """

        self._sub_context_codes = sub_context_codes

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this AppointmentGroup.
        Current state of the appointment group ('pending', 'active' or 'deleted'). 'pending' indicates that it has not been published yet and is invisible to participants.

        :return: The workflow_state of this AppointmentGroup.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this AppointmentGroup.
        Current state of the appointment group ('pending', 'active' or 'deleted'). 'pending' indicates that it has not been published yet and is invisible to participants.

        :param workflow_state: The workflow_state of this AppointmentGroup.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def requiring_action(self):
        """
        Gets the requiring_action of this AppointmentGroup.
        Boolean indicating whether the current user needs to sign up for this appointment group (i.e. it's reservable and the min_appointments_per_participant limit has not been met by this user).

        :return: The requiring_action of this AppointmentGroup.
        :rtype: bool
        """
        return self._requiring_action

    @requiring_action.setter
    def requiring_action(self, requiring_action):
        """
        Sets the requiring_action of this AppointmentGroup.
        Boolean indicating whether the current user needs to sign up for this appointment group (i.e. it's reservable and the min_appointments_per_participant limit has not been met by this user).

        :param requiring_action: The requiring_action of this AppointmentGroup.
        :type: bool
        """

        self._requiring_action = requiring_action

    @property
    def appointments_count(self):
        """
        Gets the appointments_count of this AppointmentGroup.
        Number of time slots in this appointment group

        :return: The appointments_count of this AppointmentGroup.
        :rtype: int
        """
        return self._appointments_count

    @appointments_count.setter
    def appointments_count(self, appointments_count):
        """
        Sets the appointments_count of this AppointmentGroup.
        Number of time slots in this appointment group

        :param appointments_count: The appointments_count of this AppointmentGroup.
        :type: int
        """

        self._appointments_count = appointments_count

    @property
    def appointments(self):
        """
        Gets the appointments of this AppointmentGroup.
        Calendar Events representing the time slots (see include[] argument) Refer to the Calendar Events API for more information

        :return: The appointments of this AppointmentGroup.
        :rtype: list[CalendarEvent]
        """
        return self._appointments

    @appointments.setter
    def appointments(self, appointments):
        """
        Sets the appointments of this AppointmentGroup.
        Calendar Events representing the time slots (see include[] argument) Refer to the Calendar Events API for more information

        :param appointments: The appointments of this AppointmentGroup.
        :type: list[CalendarEvent]
        """

        self._appointments = appointments

    @property
    def new_appointments(self):
        """
        Gets the new_appointments of this AppointmentGroup.
        Newly created time slots (same format as appointments above). Only returned in Create/Update responses where new time slots have been added

        :return: The new_appointments of this AppointmentGroup.
        :rtype: list[CalendarEvent]
        """
        return self._new_appointments

    @new_appointments.setter
    def new_appointments(self, new_appointments):
        """
        Sets the new_appointments of this AppointmentGroup.
        Newly created time slots (same format as appointments above). Only returned in Create/Update responses where new time slots have been added

        :param new_appointments: The new_appointments of this AppointmentGroup.
        :type: list[CalendarEvent]
        """

        self._new_appointments = new_appointments

    @property
    def max_appointments_per_participant(self):
        """
        Gets the max_appointments_per_participant of this AppointmentGroup.
        Maximum number of time slots a user may register for, or null if no limit

        :return: The max_appointments_per_participant of this AppointmentGroup.
        :rtype: int
        """
        return self._max_appointments_per_participant

    @max_appointments_per_participant.setter
    def max_appointments_per_participant(self, max_appointments_per_participant):
        """
        Sets the max_appointments_per_participant of this AppointmentGroup.
        Maximum number of time slots a user may register for, or null if no limit

        :param max_appointments_per_participant: The max_appointments_per_participant of this AppointmentGroup.
        :type: int
        """

        self._max_appointments_per_participant = max_appointments_per_participant

    @property
    def min_appointments_per_participant(self):
        """
        Gets the min_appointments_per_participant of this AppointmentGroup.
        Minimum number of time slots a user must register for. If not set, users do not need to sign up for any time slots

        :return: The min_appointments_per_participant of this AppointmentGroup.
        :rtype: int
        """
        return self._min_appointments_per_participant

    @min_appointments_per_participant.setter
    def min_appointments_per_participant(self, min_appointments_per_participant):
        """
        Sets the min_appointments_per_participant of this AppointmentGroup.
        Minimum number of time slots a user must register for. If not set, users do not need to sign up for any time slots

        :param min_appointments_per_participant: The min_appointments_per_participant of this AppointmentGroup.
        :type: int
        """

        self._min_appointments_per_participant = min_appointments_per_participant

    @property
    def participants_per_appointment(self):
        """
        Gets the participants_per_appointment of this AppointmentGroup.
        Maximum number of participants that may register for each time slot, or null if no limit

        :return: The participants_per_appointment of this AppointmentGroup.
        :rtype: int
        """
        return self._participants_per_appointment

    @participants_per_appointment.setter
    def participants_per_appointment(self, participants_per_appointment):
        """
        Sets the participants_per_appointment of this AppointmentGroup.
        Maximum number of participants that may register for each time slot, or null if no limit

        :param participants_per_appointment: The participants_per_appointment of this AppointmentGroup.
        :type: int
        """

        self._participants_per_appointment = participants_per_appointment

    @property
    def participant_visibility(self):
        """
        Gets the participant_visibility of this AppointmentGroup.
        'private' means participants cannot see who has signed up for a particular time slot, 'protected' means that they can

        :return: The participant_visibility of this AppointmentGroup.
        :rtype: str
        """
        return self._participant_visibility

    @participant_visibility.setter
    def participant_visibility(self, participant_visibility):
        """
        Sets the participant_visibility of this AppointmentGroup.
        'private' means participants cannot see who has signed up for a particular time slot, 'protected' means that they can

        :param participant_visibility: The participant_visibility of this AppointmentGroup.
        :type: str
        """

        self._participant_visibility = participant_visibility

    @property
    def participant_type(self):
        """
        Gets the participant_type of this AppointmentGroup.
        Indicates how participants sign up for the appointment group, either as individuals ('User') or in student groups ('Group'). Related to sub_context_codes (i.e. 'Group' signups always have a single group category)

        :return: The participant_type of this AppointmentGroup.
        :rtype: str
        """
        return self._participant_type

    @participant_type.setter
    def participant_type(self, participant_type):
        """
        Sets the participant_type of this AppointmentGroup.
        Indicates how participants sign up for the appointment group, either as individuals ('User') or in student groups ('Group'). Related to sub_context_codes (i.e. 'Group' signups always have a single group category)

        :param participant_type: The participant_type of this AppointmentGroup.
        :type: str
        """

        self._participant_type = participant_type

    @property
    def url(self):
        """
        Gets the url of this AppointmentGroup.
        URL for this appointment group (to update, delete, etc.)

        :return: The url of this AppointmentGroup.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this AppointmentGroup.
        URL for this appointment group (to update, delete, etc.)

        :param url: The url of this AppointmentGroup.
        :type: str
        """

        self._url = url

    @property
    def html_url(self):
        """
        Gets the html_url of this AppointmentGroup.
        URL for a user to view this appointment group

        :return: The html_url of this AppointmentGroup.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this AppointmentGroup.
        URL for a user to view this appointment group

        :param html_url: The html_url of this AppointmentGroup.
        :type: str
        """

        self._html_url = html_url

    @property
    def created_at(self):
        """
        Gets the created_at of this AppointmentGroup.
        When the appointment group was created

        :return: The created_at of this AppointmentGroup.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this AppointmentGroup.
        When the appointment group was created

        :param created_at: The created_at of this AppointmentGroup.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this AppointmentGroup.
        When the appointment group was last updated

        :return: The updated_at of this AppointmentGroup.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this AppointmentGroup.
        When the appointment group was last updated

        :param updated_at: The updated_at of this AppointmentGroup.
        :type: Datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
