# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageInfo(Model):
    """A JSON object that identities the image to get insights of . It also
    includes the optional crop area that you use to identify the region of
    interest in the image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar image_insights_token: An image insights token. To get the insights
     token, call one of the Image Search APIs (for example, /images/search). In
     the search results, the
     [Image](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#image)
     object's
     [imageInsightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#image-imageinsightstoken)
     field contains the token. The imageInsightsToken and url fields mutually
     exclusive; do not specify both. Do not specify an insights token if the
     request includes the image form data.
    :vartype image_insights_token: str
    :ivar url: The URL of the input image. The imageInsightsToken and url
     fields are mutually exclusive; do not specify both. Do not specify the URL
     if the request includes the image form data.
    :vartype url: str
    :ivar crop_area: A JSON object consisting of coordinates specifying the
     four corners of a cropped rectangle within the input image. Use the crop
     area to identify the region of interest in the image. You can apply the
     crop area to the images specified using the imageInsightsToken or url
     fields, or an image binary specified in an image form data.
    :vartype crop_area:
     ~azure.cognitiveservices.search.visualsearch.models.CropArea
    """

    _validation = {
        'image_insights_token': {'readonly': True},
        'url': {'readonly': True},
        'crop_area': {'readonly': True},
    }

    _attribute_map = {
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'crop_area': {'key': 'cropArea', 'type': 'CropArea'},
    }

    def __init__(self, **kwargs) -> None:
        super(ImageInfo, self).__init__(**kwargs)
        self.image_insights_token = None
        self.url = None
        self.crop_area = None
