# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class QuizsubmissionquestionsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: answering_questions
    def answering_questions(self, quiz_submission_id, attempt, validation_token, **kwargs):
        """
        Answering questions
        Provide or update an answer to one or more QuizQuestions.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.answering_questions_with_http_info(quiz_submission_id, attempt, validation_token, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str quiz_submission_id: ID (required)
        :param int attempt: The attempt number of the quiz submission being taken. Note that this must be the latest attempt index, as questions for earlier attempts can not be modified. (required)
        :param str validation_token: The unique validation token you received when the Quiz Submission was created. (required)
        :param str access_code: Access code for the Quiz, if any.
        :param list[Quizsubmissionquestion] quiz_questions: Set of question IDs and the answer value. See {Appendix: Question Answer Formats} for the accepted answer formats for each question type.
        :return: list[QuizSubmissionQuestion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quiz_submission_id', 'attempt', 'validation_token', 'access_code', 'quiz_questions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method answering_questions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quiz_submission_id' is set
        if ('quiz_submission_id' not in params) or (params['quiz_submission_id'] is None):
            raise ValueError("Missing the required parameter `quiz_submission_id` when calling `answering_questions`")
        # verify the required parameter 'attempt' is set
        if ('attempt' not in params) or (params['attempt'] is None):
            raise ValueError("Missing the required parameter `attempt` when calling `answering_questions`")
        # verify the required parameter 'validation_token' is set
        if ('validation_token' not in params) or (params['validation_token'] is None):
            raise ValueError("Missing the required parameter `validation_token` when calling `answering_questions`")

        resource_path = '/v1/quiz_submissions/{quiz_submission_id}/questions'.replace('{format}', 'json')
        path_params = {}
        if 'quiz_submission_id' in params:
            path_params['quiz_submission_id'] = params['quiz_submission_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'attempt' in params:
            form_params.append(('attempt', params['attempt']))
        if 'validation_token' in params:
            form_params.append(('validation_token', params['validation_token']))
        if 'access_code' in params:
            form_params.append(('access_code', params['access_code']))
        if 'quiz_questions' in params:
            form_params.append(('quiz_questions', params['quiz_questions']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[QuizSubmissionQuestion]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: flagging_question
    def flagging_question(self, quiz_submission_id, id, attempt, validation_token, **kwargs):
        """
        Flagging a question.
        Set a flag on a quiz question to indicate that you want to return to it later.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.flagging_question_with_http_info(quiz_submission_id, id, attempt, validation_token, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str quiz_submission_id: ID (required)
        :param str id: ID (required)
        :param int attempt: The attempt number of the quiz submission being taken. Note that this must be the latest attempt index, as questions for earlier attempts can not be modified. (required)
        :param str validation_token: The unique validation token you received when the Quiz Submission was created. (required)
        :param str access_code: Access code for the Quiz, if any.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quiz_submission_id', 'id', 'attempt', 'validation_token', 'access_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method flagging_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quiz_submission_id' is set
        if ('quiz_submission_id' not in params) or (params['quiz_submission_id'] is None):
            raise ValueError("Missing the required parameter `quiz_submission_id` when calling `flagging_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `flagging_question`")
        # verify the required parameter 'attempt' is set
        if ('attempt' not in params) or (params['attempt'] is None):
            raise ValueError("Missing the required parameter `attempt` when calling `flagging_question`")
        # verify the required parameter 'validation_token' is set
        if ('validation_token' not in params) or (params['validation_token'] is None):
            raise ValueError("Missing the required parameter `validation_token` when calling `flagging_question`")

        resource_path = '/v1/quiz_submissions/{quiz_submission_id}/questions/{id}/flag'.replace('{format}', 'json')
        path_params = {}
        if 'quiz_submission_id' in params:
            path_params['quiz_submission_id'] = params['quiz_submission_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'attempt' in params:
            form_params.append(('attempt', params['attempt']))
        if 'validation_token' in params:
            form_params.append(('validation_token', params['validation_token']))
        if 'access_code' in params:
            form_params.append(('access_code', params['access_code']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_quiz_submission_questions
    def get_all_quiz_submission_questions(self, quiz_submission_id, **kwargs):
        """
        Get all quiz submission questions.
        Get a list of all the question records for this quiz submission.  <b>200 OK</b> response code is returned if the request was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_quiz_submission_questions_with_http_info(quiz_submission_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str quiz_submission_id: ID (required)
        :param list[str] include: Associations to include with the quiz submission question.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quiz_submission_id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_quiz_submission_questions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quiz_submission_id' is set
        if ('quiz_submission_id' not in params) or (params['quiz_submission_id'] is None):
            raise ValueError("Missing the required parameter `quiz_submission_id` when calling `get_all_quiz_submission_questions`")

        resource_path = '/v1/quiz_submissions/{quiz_submission_id}/questions'.replace('{format}', 'json')
        path_params = {}
        if 'quiz_submission_id' in params:
            path_params['quiz_submission_id'] = params['quiz_submission_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_quiz_submission_question
    def get_single_quiz_submission_question(self, quiz_submission_id, id, **kwargs):
        """
        Get a single quiz submission question.
        Get a single question record.  <b>200 OK</b> response code is returned if the request was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_quiz_submission_question_with_http_info(quiz_submission_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str quiz_submission_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: Associations to include with the quiz submission question.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quiz_submission_id', 'id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_quiz_submission_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quiz_submission_id' is set
        if ('quiz_submission_id' not in params) or (params['quiz_submission_id'] is None):
            raise ValueError("Missing the required parameter `quiz_submission_id` when calling `get_single_quiz_submission_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_quiz_submission_question`")

        resource_path = '/v1/quiz_submissions/{quiz_submission_id}/questions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'quiz_submission_id' in params:
            path_params['quiz_submission_id'] = params['quiz_submission_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unflagging_question
    def unflagging_question(self, quiz_submission_id, id, attempt, validation_token, **kwargs):
        """
        Unflagging a question.
        Remove the flag that you previously set on a quiz question after you've returned to it.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unflagging_question_with_http_info(quiz_submission_id, id, attempt, validation_token, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str quiz_submission_id: ID (required)
        :param str id: ID (required)
        :param int attempt: The attempt number of the quiz submission being taken. Note that this must be the latest attempt index, as questions for earlier attempts can not be modified. (required)
        :param str validation_token: The unique validation token you received when the Quiz Submission was created. (required)
        :param str access_code: Access code for the Quiz, if any.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quiz_submission_id', 'id', 'attempt', 'validation_token', 'access_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unflagging_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quiz_submission_id' is set
        if ('quiz_submission_id' not in params) or (params['quiz_submission_id'] is None):
            raise ValueError("Missing the required parameter `quiz_submission_id` when calling `unflagging_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `unflagging_question`")
        # verify the required parameter 'attempt' is set
        if ('attempt' not in params) or (params['attempt'] is None):
            raise ValueError("Missing the required parameter `attempt` when calling `unflagging_question`")
        # verify the required parameter 'validation_token' is set
        if ('validation_token' not in params) or (params['validation_token'] is None):
            raise ValueError("Missing the required parameter `validation_token` when calling `unflagging_question`")

        resource_path = '/v1/quiz_submissions/{quiz_submission_id}/questions/{id}/unflag'.replace('{format}', 'json')
        path_params = {}
        if 'quiz_submission_id' in params:
            path_params['quiz_submission_id'] = params['quiz_submission_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'attempt' in params:
            form_params.append(('attempt', params['attempt']))
        if 'validation_token' in params:
            form_params.append(('validation_token', params['validation_token']))
        if 'access_code' in params:
            form_params.append(('access_code', params['access_code']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
