# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizStatistics(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, quiz_id=None, multiple_attempts_exist=None, includes_all_versions=None, generated_at=None, url=None, html_url=None, question_statistics=None, submission_statistics=None, links=None):
        """
        QuizStatistics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'quiz_id': 'int',
            'multiple_attempts_exist': 'bool',
            'includes_all_versions': 'bool',
            'generated_at': 'Datetime',
            'url': 'str',
            'html_url': 'str',
            'question_statistics': 'QuizStatisticsQuestionStatistics',
            'submission_statistics': 'QuizStatisticsSubmissionStatistics',
            'links': 'QuizStatisticsLinks'
        }

        self.attribute_map = {
            'id': 'id',
            'quiz_id': 'quiz_id',
            'multiple_attempts_exist': 'multiple_attempts_exist',
            'includes_all_versions': 'includes_all_versions',
            'generated_at': 'generated_at',
            'url': 'url',
            'html_url': 'html_url',
            'question_statistics': 'question_statistics',
            'submission_statistics': 'submission_statistics',
            'links': 'links'
        }

        self._id = id
        self._quiz_id = quiz_id
        self._multiple_attempts_exist = multiple_attempts_exist
        self._includes_all_versions = includes_all_versions
        self._generated_at = generated_at
        self._url = url
        self._html_url = html_url
        self._question_statistics = question_statistics
        self._submission_statistics = submission_statistics
        self._links = links

    @property
    def id(self):
        """
        Gets the id of this QuizStatistics.
        The ID of the quiz statistics report.

        :return: The id of this QuizStatistics.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizStatistics.
        The ID of the quiz statistics report.

        :param id: The id of this QuizStatistics.
        :type: int
        """

        self._id = id

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizStatistics.
        The ID of the Quiz the statistics report is for.  NOTE: AVAILABLE ONLY IN NON-JSON-API REQUESTS.

        :return: The quiz_id of this QuizStatistics.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizStatistics.
        The ID of the Quiz the statistics report is for.  NOTE: AVAILABLE ONLY IN NON-JSON-API REQUESTS.

        :param quiz_id: The quiz_id of this QuizStatistics.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def multiple_attempts_exist(self):
        """
        Gets the multiple_attempts_exist of this QuizStatistics.
        Whether there are any students that have made mutliple submissions for this quiz.

        :return: The multiple_attempts_exist of this QuizStatistics.
        :rtype: bool
        """
        return self._multiple_attempts_exist

    @multiple_attempts_exist.setter
    def multiple_attempts_exist(self, multiple_attempts_exist):
        """
        Sets the multiple_attempts_exist of this QuizStatistics.
        Whether there are any students that have made mutliple submissions for this quiz.

        :param multiple_attempts_exist: The multiple_attempts_exist of this QuizStatistics.
        :type: bool
        """

        self._multiple_attempts_exist = multiple_attempts_exist

    @property
    def includes_all_versions(self):
        """
        Gets the includes_all_versions of this QuizStatistics.
        In the presence of multiple attempts, this field describes whether the statistics describe all the submission attempts and not only the latest ones.

        :return: The includes_all_versions of this QuizStatistics.
        :rtype: bool
        """
        return self._includes_all_versions

    @includes_all_versions.setter
    def includes_all_versions(self, includes_all_versions):
        """
        Sets the includes_all_versions of this QuizStatistics.
        In the presence of multiple attempts, this field describes whether the statistics describe all the submission attempts and not only the latest ones.

        :param includes_all_versions: The includes_all_versions of this QuizStatistics.
        :type: bool
        """

        self._includes_all_versions = includes_all_versions

    @property
    def generated_at(self):
        """
        Gets the generated_at of this QuizStatistics.
        The time at which the statistics were generated, which is usually after the occurrence of a quiz event, like a student submitting it.

        :return: The generated_at of this QuizStatistics.
        :rtype: Datetime
        """
        return self._generated_at

    @generated_at.setter
    def generated_at(self, generated_at):
        """
        Sets the generated_at of this QuizStatistics.
        The time at which the statistics were generated, which is usually after the occurrence of a quiz event, like a student submitting it.

        :param generated_at: The generated_at of this QuizStatistics.
        :type: Datetime
        """

        self._generated_at = generated_at

    @property
    def url(self):
        """
        Gets the url of this QuizStatistics.
        The API HTTP/HTTPS URL to this quiz statistics.

        :return: The url of this QuizStatistics.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this QuizStatistics.
        The API HTTP/HTTPS URL to this quiz statistics.

        :param url: The url of this QuizStatistics.
        :type: str
        """

        self._url = url

    @property
    def html_url(self):
        """
        Gets the html_url of this QuizStatistics.
        The HTTP/HTTPS URL to the page where the statistics can be seen visually.

        :return: The html_url of this QuizStatistics.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this QuizStatistics.
        The HTTP/HTTPS URL to the page where the statistics can be seen visually.

        :param html_url: The html_url of this QuizStatistics.
        :type: str
        """

        self._html_url = html_url

    @property
    def question_statistics(self):
        """
        Gets the question_statistics of this QuizStatistics.
        Question-specific statistics for each question and its answers.

        :return: The question_statistics of this QuizStatistics.
        :rtype: QuizStatisticsQuestionStatistics
        """
        return self._question_statistics

    @question_statistics.setter
    def question_statistics(self, question_statistics):
        """
        Sets the question_statistics of this QuizStatistics.
        Question-specific statistics for each question and its answers.

        :param question_statistics: The question_statistics of this QuizStatistics.
        :type: QuizStatisticsQuestionStatistics
        """

        self._question_statistics = question_statistics

    @property
    def submission_statistics(self):
        """
        Gets the submission_statistics of this QuizStatistics.
        Question-specific statistics for each question and its answers.

        :return: The submission_statistics of this QuizStatistics.
        :rtype: QuizStatisticsSubmissionStatistics
        """
        return self._submission_statistics

    @submission_statistics.setter
    def submission_statistics(self, submission_statistics):
        """
        Sets the submission_statistics of this QuizStatistics.
        Question-specific statistics for each question and its answers.

        :param submission_statistics: The submission_statistics of this QuizStatistics.
        :type: QuizStatisticsSubmissionStatistics
        """

        self._submission_statistics = submission_statistics

    @property
    def links(self):
        """
        Gets the links of this QuizStatistics.
        JSON-API construct that contains links to media related to this quiz statistics object.  NOTE: AVAILABLE ONLY IN JSON-API REQUESTS.

        :return: The links of this QuizStatistics.
        :rtype: QuizStatisticsLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this QuizStatistics.
        JSON-API construct that contains links to media related to this quiz statistics object.  NOTE: AVAILABLE ONLY IN JSON-API REQUESTS.

        :param links: The links of this QuizStatistics.
        :type: QuizStatisticsLinks
        """

        self._links = links

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
