# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class PagesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_page_courses
    def create_page_courses(self, course_id, wiki_page_title, **kwargs):
        """
        Create page
        Create a new wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_page_courses_with_http_info(course_id, wiki_page_title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str wiki_page_title: The title for the new page. (required)
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :param bool wiki_page_front_page: Set an unhidden page as the front page (if true)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published', 'wiki_page_front_page']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_page_courses`")
        # verify the required parameter 'wiki_page_title' is set
        if ('wiki_page_title' not in params) or (params['wiki_page_title'] is None):
            raise ValueError("Missing the required parameter `wiki_page_title` when calling `create_page_courses`")

        resource_path = '/v1/courses/{course_id}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))
        if 'wiki_page_front_page' in params:
            form_params.append(('wiki_page[front_page]', params['wiki_page_front_page']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_page_groups
    def create_page_groups(self, group_id, wiki_page_title, **kwargs):
        """
        Create page
        Create a new wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_page_groups_with_http_info(group_id, wiki_page_title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str wiki_page_title: The title for the new page. (required)
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :param bool wiki_page_front_page: Set an unhidden page as the front page (if true)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published', 'wiki_page_front_page']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_page_groups`")
        # verify the required parameter 'wiki_page_title' is set
        if ('wiki_page_title' not in params) or (params['wiki_page_title'] is None):
            raise ValueError("Missing the required parameter `wiki_page_title` when calling `create_page_groups`")

        resource_path = '/v1/groups/{group_id}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))
        if 'wiki_page_front_page' in params:
            form_params.append(('wiki_page[front_page]', params['wiki_page_front_page']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_page_courses
    def delete_page_courses(self, course_id, url, **kwargs):
        """
        Delete page
        Delete a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_courses_with_http_info(course_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_page_courses`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `delete_page_courses`")

        resource_path = '/v1/courses/{course_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_page_groups
    def delete_page_groups(self, group_id, url, **kwargs):
        """
        Delete page
        Delete a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_groups_with_http_info(group_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `delete_page_groups`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `delete_page_groups`")

        resource_path = '/v1/groups/{group_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_pages_courses
    def list_pages_courses(self, course_id, **kwargs):
        """
        List pages
        List the wiki pages associated with a course or group

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pages_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str sort: Sort results by this field.
        :param str order: The sorting order. Defaults to 'asc'.
        :param str search_term: The partial title of the pages to match and return.
        :param bool published: If true, include only published paqes. If false, exclude published pages. If not present, do not filter on published status.
        :return: list[Page]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'sort', 'order', 'search_term', 'published']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pages_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_pages_courses`")

        resource_path = '/v1/courses/{course_id}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'sort' in params:
            query_params['sort'] = params['sort']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'published' in params:
            query_params['published'] = params['published']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Page]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_pages_groups
    def list_pages_groups(self, group_id, **kwargs):
        """
        List pages
        List the wiki pages associated with a course or group

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pages_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str sort: Sort results by this field.
        :param str order: The sorting order. Defaults to 'asc'.
        :param str search_term: The partial title of the pages to match and return.
        :param bool published: If true, include only published paqes. If false, exclude published pages. If not present, do not filter on published status.
        :return: list[Page]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'sort', 'order', 'search_term', 'published']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pages_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_pages_groups`")

        resource_path = '/v1/groups/{group_id}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'sort' in params:
            query_params['sort'] = params['sort']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'published' in params:
            query_params['published'] = params['published']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Page]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_revisions_courses
    def list_revisions_courses(self, course_id, url, **kwargs):
        """
        List revisions
        List the revisions of a page. Callers must have update rights on the page in order to see page history.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_revisions_courses_with_http_info(course_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :return: list[PageRevision]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_revisions_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_revisions_courses`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `list_revisions_courses`")

        resource_path = '/v1/courses/{course_id}/pages/{url}/revisions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[PageRevision]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_revisions_groups
    def list_revisions_groups(self, group_id, url, **kwargs):
        """
        List revisions
        List the revisions of a page. Callers must have update rights on the page in order to see page history.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_revisions_groups_with_http_info(group_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :return: list[PageRevision]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_revisions_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_revisions_groups`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `list_revisions_groups`")

        resource_path = '/v1/groups/{group_id}/pages/{url}/revisions'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[PageRevision]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: revert_to_revision_courses
    def revert_to_revision_courses(self, course_id, url, revision_id, **kwargs):
        """
        Revert to revision
        Revert a page to a prior revision.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revert_to_revision_courses_with_http_info(course_id, url, revision_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :param int revision_id: The revision to revert to (use the {api:WikiPagesApiController#revisions List Revisions API} to see available revisions) (required)
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url', 'revision_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_to_revision_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `revert_to_revision_courses`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `revert_to_revision_courses`")
        # verify the required parameter 'revision_id' is set
        if ('revision_id' not in params) or (params['revision_id'] is None):
            raise ValueError("Missing the required parameter `revision_id` when calling `revert_to_revision_courses`")

        resource_path = '/v1/courses/{course_id}/pages/{url}/revisions/{revision_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']
        if 'revision_id' in params:
            path_params['revision_id'] = params['revision_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: revert_to_revision_groups
    def revert_to_revision_groups(self, group_id, url, revision_id, **kwargs):
        """
        Revert to revision
        Revert a page to a prior revision.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revert_to_revision_groups_with_http_info(group_id, url, revision_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :param int revision_id: The revision to revert to (use the {api:WikiPagesApiController#revisions List Revisions API} to see available revisions) (required)
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url', 'revision_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_to_revision_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `revert_to_revision_groups`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `revert_to_revision_groups`")
        # verify the required parameter 'revision_id' is set
        if ('revision_id' not in params) or (params['revision_id'] is None):
            raise ValueError("Missing the required parameter `revision_id` when calling `revert_to_revision_groups`")

        resource_path = '/v1/groups/{group_id}/pages/{url}/revisions/{revision_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']
        if 'revision_id' in params:
            path_params['revision_id'] = params['revision_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_front_page_courses
    def show_front_page_courses(self, course_id, **kwargs):
        """
        Show front page
        Retrieve the content of the front page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_front_page_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_front_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_front_page_courses`")

        resource_path = '/v1/courses/{course_id}/front_page'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_front_page_groups
    def show_front_page_groups(self, group_id, **kwargs):
        """
        Show front page
        Retrieve the content of the front page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_front_page_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_front_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `show_front_page_groups`")

        resource_path = '/v1/groups/{group_id}/front_page'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_page_courses
    def show_page_courses(self, course_id, url, **kwargs):
        """
        Show page
        Retrieve the content of a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_page_courses_with_http_info(course_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_page_courses`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_page_courses`")

        resource_path = '/v1/courses/{course_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_page_groups
    def show_page_groups(self, group_id, url, **kwargs):
        """
        Show page
        Retrieve the content of a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_page_groups_with_http_info(group_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `show_page_groups`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_page_groups`")

        resource_path = '/v1/groups/{group_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_revision_courses_latest
    def show_revision_courses_latest(self, course_id, url, **kwargs):
        """
        Show revision
        Retrieve the metadata and optionally content of a revision of the page. Note that retrieving historic versions of pages requires edit rights.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_revision_courses_latest_with_http_info(course_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :param bool summary: If set, exclude page content from results
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url', 'summary']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_revision_courses_latest" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_revision_courses_latest`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_revision_courses_latest`")

        resource_path = '/v1/courses/{course_id}/pages/{url}/revisions/latest'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_revision_courses_revision_id
    def show_revision_courses_revision_id(self, course_id, url, revision_id, **kwargs):
        """
        Show revision
        Retrieve the metadata and optionally content of a revision of the page. Note that retrieving historic versions of pages requires edit rights.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_revision_courses_revision_id_with_http_info(course_id, url, revision_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :param str revision_id: ID (required)
        :param bool summary: If set, exclude page content from results
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url', 'revision_id', 'summary']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_revision_courses_revision_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_revision_courses_revision_id`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_revision_courses_revision_id`")
        # verify the required parameter 'revision_id' is set
        if ('revision_id' not in params) or (params['revision_id'] is None):
            raise ValueError("Missing the required parameter `revision_id` when calling `show_revision_courses_revision_id`")

        resource_path = '/v1/courses/{course_id}/pages/{url}/revisions/{revision_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']
        if 'revision_id' in params:
            path_params['revision_id'] = params['revision_id']

        query_params = {}
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_revision_groups_latest
    def show_revision_groups_latest(self, group_id, url, **kwargs):
        """
        Show revision
        Retrieve the metadata and optionally content of a revision of the page. Note that retrieving historic versions of pages requires edit rights.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_revision_groups_latest_with_http_info(group_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :param bool summary: If set, exclude page content from results
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url', 'summary']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_revision_groups_latest" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `show_revision_groups_latest`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_revision_groups_latest`")

        resource_path = '/v1/groups/{group_id}/pages/{url}/revisions/latest'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_revision_groups_revision_id
    def show_revision_groups_revision_id(self, group_id, url, revision_id, **kwargs):
        """
        Show revision
        Retrieve the metadata and optionally content of a revision of the page. Note that retrieving historic versions of pages requires edit rights.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_revision_groups_revision_id_with_http_info(group_id, url, revision_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :param str revision_id: ID (required)
        :param bool summary: If set, exclude page content from results
        :return: PageRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url', 'revision_id', 'summary']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_revision_groups_revision_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `show_revision_groups_revision_id`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `show_revision_groups_revision_id`")
        # verify the required parameter 'revision_id' is set
        if ('revision_id' not in params) or (params['revision_id'] is None):
            raise ValueError("Missing the required parameter `revision_id` when calling `show_revision_groups_revision_id`")

        resource_path = '/v1/groups/{group_id}/pages/{url}/revisions/{revision_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']
        if 'revision_id' in params:
            path_params['revision_id'] = params['revision_id']

        query_params = {}
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PageRevision',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_create_front_page_courses
    def update_create_front_page_courses(self, course_id, **kwargs):
        """
        Update/create front page
        Update the title or contents of the front page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_create_front_page_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str wiki_page_title: The title for the new page. NOTE: changing a page's title will change its url. The updated url will be returned in the result.
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_create_front_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_create_front_page_courses`")

        resource_path = '/v1/courses/{course_id}/front_page'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_create_front_page_groups
    def update_create_front_page_groups(self, group_id, **kwargs):
        """
        Update/create front page
        Update the title or contents of the front page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_create_front_page_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str wiki_page_title: The title for the new page. NOTE: changing a page's title will change its url. The updated url will be returned in the result.
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_create_front_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_create_front_page_groups`")

        resource_path = '/v1/groups/{group_id}/front_page'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_create_page_courses
    def update_create_page_courses(self, course_id, url, **kwargs):
        """
        Update/create page
        Update the title or contents of a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_create_page_courses_with_http_info(course_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str url: ID (required)
        :param str wiki_page_title: The title for the new page. NOTE: changing a page's title will change its url. The updated url will be returned in the result.
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :param bool wiki_page_front_page: Set an unhidden page as the front page (if true)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'url', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published', 'wiki_page_front_page']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_create_page_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_create_page_courses`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `update_create_page_courses`")

        resource_path = '/v1/courses/{course_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))
        if 'wiki_page_front_page' in params:
            form_params.append(('wiki_page[front_page]', params['wiki_page_front_page']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_create_page_groups
    def update_create_page_groups(self, group_id, url, **kwargs):
        """
        Update/create page
        Update the title or contents of a wiki page

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_create_page_groups_with_http_info(group_id, url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str url: ID (required)
        :param str wiki_page_title: The title for the new page. NOTE: changing a page's title will change its url. The updated url will be returned in the result.
        :param str wiki_page_body: The content for the new page.
        :param str wiki_page_editing_roles: Which user roles are allowed to edit this page. Any combination of these roles is allowed (separated by commas). \"teachers\":: Allows editing by teachers in the course. \"students\":: Allows editing by students in the course. \"members\":: For group wikis, allows editing by members of the group. \"public\":: Allows editing by any user.
        :param bool wiki_page_notify_of_update: Whether participants should be notified when this page changes.
        :param bool wiki_page_published: Whether the page is published (true) or draft state (false).
        :param bool wiki_page_front_page: Set an unhidden page as the front page (if true)
        :return: Page
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'url', 'wiki_page_title', 'wiki_page_body', 'wiki_page_editing_roles', 'wiki_page_notify_of_update', 'wiki_page_published', 'wiki_page_front_page']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_create_page_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_create_page_groups`")
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `update_create_page_groups`")

        resource_path = '/v1/groups/{group_id}/pages/{url}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'url' in params:
            path_params['url'] = params['url']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'wiki_page_title' in params:
            form_params.append(('wiki_page[title]', params['wiki_page_title']))
        if 'wiki_page_body' in params:
            form_params.append(('wiki_page[body]', params['wiki_page_body']))
        if 'wiki_page_editing_roles' in params:
            form_params.append(('wiki_page[editing_roles]', params['wiki_page_editing_roles']))
        if 'wiki_page_notify_of_update' in params:
            form_params.append(('wiki_page[notify_of_update]', params['wiki_page_notify_of_update']))
        if 'wiki_page_published' in params:
            form_params.append(('wiki_page[published]', params['wiki_page_published']))
        if 'wiki_page_front_page' in params:
            form_params.append(('wiki_page[front_page]', params['wiki_page_front_page']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Page',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
