# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Module(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, workflow_state=None, position=None, name=None, unlock_at=None, require_sequential_progress=None, prerequisite_module_ids=None, items_count=None, items_url=None, items=None, state=None, completed_at=None, publish_final_grade=None):
        """
        Module - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'workflow_state': 'str',
            'position': 'int',
            'name': 'str',
            'unlock_at': 'Datetime',
            'require_sequential_progress': 'bool',
            'prerequisite_module_ids': 'list[int]',
            'items_count': 'int',
            'items_url': 'str',
            'items': 'list[ModuleItem]',
            'state': 'str',
            'completed_at': 'Datetime',
            'publish_final_grade': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'workflow_state': 'workflow_state',
            'position': 'position',
            'name': 'name',
            'unlock_at': 'unlock_at',
            'require_sequential_progress': 'require_sequential_progress',
            'prerequisite_module_ids': 'prerequisite_module_ids',
            'items_count': 'items_count',
            'items_url': 'items_url',
            'items': 'items',
            'state': 'state',
            'completed_at': 'completed_at',
            'publish_final_grade': 'publish_final_grade'
        }

        self._id = id
        self._workflow_state = workflow_state
        self._position = position
        self._name = name
        self._unlock_at = unlock_at
        self._require_sequential_progress = require_sequential_progress
        self._prerequisite_module_ids = prerequisite_module_ids
        self._items_count = items_count
        self._items_url = items_url
        self._items = items
        self._state = state
        self._completed_at = completed_at
        self._publish_final_grade = publish_final_grade

    @property
    def id(self):
        """
        Gets the id of this Module.
        the unique identifier for the module

        :return: The id of this Module.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Module.
        the unique identifier for the module

        :param id: The id of this Module.
        :type: int
        """

        self._id = id

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this Module.
        the state of the module: 'active', 'deleted'

        :return: The workflow_state of this Module.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this Module.
        the state of the module: 'active', 'deleted'

        :param workflow_state: The workflow_state of this Module.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def position(self):
        """
        Gets the position of this Module.
        the position of this module in the course (1-based)

        :return: The position of this Module.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this Module.
        the position of this module in the course (1-based)

        :param position: The position of this Module.
        :type: int
        """

        self._position = position

    @property
    def name(self):
        """
        Gets the name of this Module.
        the name of this module

        :return: The name of this Module.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Module.
        the name of this module

        :param name: The name of this Module.
        :type: str
        """

        self._name = name

    @property
    def unlock_at(self):
        """
        Gets the unlock_at of this Module.
        (Optional) the date this module will unlock

        :return: The unlock_at of this Module.
        :rtype: Datetime
        """
        return self._unlock_at

    @unlock_at.setter
    def unlock_at(self, unlock_at):
        """
        Sets the unlock_at of this Module.
        (Optional) the date this module will unlock

        :param unlock_at: The unlock_at of this Module.
        :type: Datetime
        """

        self._unlock_at = unlock_at

    @property
    def require_sequential_progress(self):
        """
        Gets the require_sequential_progress of this Module.
        Whether module items must be unlocked in order

        :return: The require_sequential_progress of this Module.
        :rtype: bool
        """
        return self._require_sequential_progress

    @require_sequential_progress.setter
    def require_sequential_progress(self, require_sequential_progress):
        """
        Sets the require_sequential_progress of this Module.
        Whether module items must be unlocked in order

        :param require_sequential_progress: The require_sequential_progress of this Module.
        :type: bool
        """

        self._require_sequential_progress = require_sequential_progress

    @property
    def prerequisite_module_ids(self):
        """
        Gets the prerequisite_module_ids of this Module.
        IDs of Modules that must be completed before this one is unlocked

        :return: The prerequisite_module_ids of this Module.
        :rtype: list[int]
        """
        return self._prerequisite_module_ids

    @prerequisite_module_ids.setter
    def prerequisite_module_ids(self, prerequisite_module_ids):
        """
        Sets the prerequisite_module_ids of this Module.
        IDs of Modules that must be completed before this one is unlocked

        :param prerequisite_module_ids: The prerequisite_module_ids of this Module.
        :type: list[int]
        """

        self._prerequisite_module_ids = prerequisite_module_ids

    @property
    def items_count(self):
        """
        Gets the items_count of this Module.
        The number of items in the module

        :return: The items_count of this Module.
        :rtype: int
        """
        return self._items_count

    @items_count.setter
    def items_count(self, items_count):
        """
        Sets the items_count of this Module.
        The number of items in the module

        :param items_count: The items_count of this Module.
        :type: int
        """

        self._items_count = items_count

    @property
    def items_url(self):
        """
        Gets the items_url of this Module.
        The API URL to retrive this module's items

        :return: The items_url of this Module.
        :rtype: str
        """
        return self._items_url

    @items_url.setter
    def items_url(self, items_url):
        """
        Sets the items_url of this Module.
        The API URL to retrive this module's items

        :param items_url: The items_url of this Module.
        :type: str
        """

        self._items_url = items_url

    @property
    def items(self):
        """
        Gets the items of this Module.
        The contents of this module, as an array of Module Items. (Present only if requested via include[]=items AND the module is not deemed too large by Canvas.)

        :return: The items of this Module.
        :rtype: list[ModuleItem]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this Module.
        The contents of this module, as an array of Module Items. (Present only if requested via include[]=items AND the module is not deemed too large by Canvas.)

        :param items: The items of this Module.
        :type: list[ModuleItem]
        """

        self._items = items

    @property
    def state(self):
        """
        Gets the state of this Module.
        The state of this Module for the calling user one of 'locked', 'unlocked', 'started', 'completed' (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :return: The state of this Module.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Module.
        The state of this Module for the calling user one of 'locked', 'unlocked', 'started', 'completed' (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :param state: The state of this Module.
        :type: str
        """

        self._state = state

    @property
    def completed_at(self):
        """
        Gets the completed_at of this Module.
        the date the calling user completed the module (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :return: The completed_at of this Module.
        :rtype: Datetime
        """
        return self._completed_at

    @completed_at.setter
    def completed_at(self, completed_at):
        """
        Sets the completed_at of this Module.
        the date the calling user completed the module (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :param completed_at: The completed_at of this Module.
        :type: Datetime
        """

        self._completed_at = completed_at

    @property
    def publish_final_grade(self):
        """
        Gets the publish_final_grade of this Module.
        if the student's final grade for the course should be published to the SIS upon completion of this module

        :return: The publish_final_grade of this Module.
        :rtype: bool
        """
        return self._publish_final_grade

    @publish_final_grade.setter
    def publish_final_grade(self, publish_final_grade):
        """
        Sets the publish_final_grade of this Module.
        if the student's final grade for the course should be published to the SIS upon completion of this module

        :param publish_final_grade: The publish_final_grade of this Module.
        :type: bool
        """

        self._publish_final_grade = publish_final_grade

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
