# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class ModulesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_module
    def create_module(self, course_id, module_name, **kwargs):
        """
        Create a module
        Create and return a new module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_module_with_http_info(course_id, module_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_name: The name of the module (required)
        :param Object module_unlock_at: The date the module will unlock
        :param int module_position: The position of this module in the course (1-based)
        :param bool module_require_sequential_progress: Whether module items must be unlocked in order
        :param list[str] module_prerequisite_module_ids: IDs of Modules that must be completed before this one is unlocked. Prerequisite modules must precede this module (i.e. have a lower position value), otherwise they will be ignored
        :param bool module_publish_final_grade: Whether to publish the student's final grade for the course upon completion of this module.
        :return: Module
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_name', 'module_unlock_at', 'module_position', 'module_require_sequential_progress', 'module_prerequisite_module_ids', 'module_publish_final_grade']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_module" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_module`")
        # verify the required parameter 'module_name' is set
        if ('module_name' not in params) or (params['module_name'] is None):
            raise ValueError("Missing the required parameter `module_name` when calling `create_module`")

        resource_path = '/v1/courses/{course_id}/modules'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'module_name' in params:
            form_params.append(('module[name]', params['module_name']))
        if 'module_unlock_at' in params:
            form_params.append(('module[unlock_at]', params['module_unlock_at']))
        if 'module_position' in params:
            form_params.append(('module[position]', params['module_position']))
        if 'module_require_sequential_progress' in params:
            form_params.append(('module[require_sequential_progress]', params['module_require_sequential_progress']))
        if 'module_prerequisite_module_ids' in params:
            form_params.append(('module[prerequisite_module_ids]', params['module_prerequisite_module_ids']))
        if 'module_publish_final_grade' in params:
            form_params.append(('module[publish_final_grade]', params['module_publish_final_grade']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Module',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_module_item
    def create_module_item(self, course_id, module_id, module_item_type, module_item_content_id, **kwargs):
        """
        Create a module item
        Create and return a new module item

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_module_item_with_http_info(course_id, module_id, module_item_type, module_item_content_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param str module_item_type: The type of content linked to the item (required)
        :param str module_item_content_id: The id of the content to link to the module item. Required, except for 'ExternalUrl', 'Page', and 'SubHeader' types. (required)
        :param str module_item_title: The name of the module item and associated content
        :param int module_item_position: The position of this item in the module (1-based).
        :param int module_item_indent: 0-based indent level; module items may be indented to show a hierarchy
        :param str module_item_page_url: Suffix for the linked wiki page (e.g. 'front-page'). Required for 'Page' type.
        :param str module_item_external_url: External url that the item points to. [Required for 'ExternalUrl' and 'ExternalTool' types.
        :param bool module_item_new_tab: Whether the external tool opens in a new tab. Only applies to 'ExternalTool' type.
        :param str module_item_completion_requirement_type: Completion requirement for this module item. \"must_view\": Applies to all item types \"must_contribute\": Only applies to \"Assignment\", \"Discussion\", and \"Page\" types \"must_submit\", \"min_score\": Only apply to \"Assignment\" and \"Quiz\" types Inapplicable types will be ignored
        :param int module_item_completion_requirement_min_score: Minimum score required to complete. Required for completion_requirement type 'min_score'.
        :return: ModuleItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'module_item_type', 'module_item_content_id', 'module_item_title', 'module_item_position', 'module_item_indent', 'module_item_page_url', 'module_item_external_url', 'module_item_new_tab', 'module_item_completion_requirement_type', 'module_item_completion_requirement_min_score']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_module_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_module_item`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `create_module_item`")
        # verify the required parameter 'module_item_type' is set
        if ('module_item_type' not in params) or (params['module_item_type'] is None):
            raise ValueError("Missing the required parameter `module_item_type` when calling `create_module_item`")
        # verify the required parameter 'module_item_content_id' is set
        if ('module_item_content_id' not in params) or (params['module_item_content_id'] is None):
            raise ValueError("Missing the required parameter `module_item_content_id` when calling `create_module_item`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'module_item_title' in params:
            form_params.append(('module_item[title]', params['module_item_title']))
        if 'module_item_type' in params:
            form_params.append(('module_item[type]', params['module_item_type']))
        if 'module_item_content_id' in params:
            form_params.append(('module_item[content_id]', params['module_item_content_id']))
        if 'module_item_position' in params:
            form_params.append(('module_item[position]', params['module_item_position']))
        if 'module_item_indent' in params:
            form_params.append(('module_item[indent]', params['module_item_indent']))
        if 'module_item_page_url' in params:
            form_params.append(('module_item[page_url]', params['module_item_page_url']))
        if 'module_item_external_url' in params:
            form_params.append(('module_item[external_url]', params['module_item_external_url']))
        if 'module_item_new_tab' in params:
            form_params.append(('module_item[new_tab]', params['module_item_new_tab']))
        if 'module_item_completion_requirement_type' in params:
            form_params.append(('module_item[completion_requirement][type]', params['module_item_completion_requirement_type']))
        if 'module_item_completion_requirement_min_score' in params:
            form_params.append(('module_item[completion_requirement][min_score]', params['module_item_completion_requirement_min_score']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModuleItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_module
    def delete_module(self, course_id, id, **kwargs):
        """
        Delete module
        Delete a module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_module_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: Module
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_module" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_module`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_module`")

        resource_path = '/v1/courses/{course_id}/modules/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Module',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_module_item
    def delete_module_item(self, course_id, module_id, id, **kwargs):
        """
        Delete module item
        Delete a module item

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_module_item_with_http_info(course_id, module_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param str id: ID (required)
        :return: ModuleItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_module_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_module_item`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `delete_module_item`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_module_item`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModuleItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_module_item_sequence
    def get_module_item_sequence(self, course_id, **kwargs):
        """
        Get module item sequence
        Given an asset in a course, find the ModuleItem it belongs to, and also the previous and next Module Items in the course sequence.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_module_item_sequence_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str asset_type: The type of asset to find module sequence information for. Use the ModuleItem if it is known (e.g., the user navigated from a module item), since this will avoid ambiguity if the asset appears more than once in the module sequence.
        :param int asset_id: The id of the asset (or the url in the case of a Page)
        :return: ModuleItemSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'asset_type', 'asset_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_module_item_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_module_item_sequence`")

        resource_path = '/v1/courses/{course_id}/module_item_sequence'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'asset_type' in params:
            query_params['asset_type'] = params['asset_type']
        if 'asset_id' in params:
            query_params['asset_id'] = params['asset_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModuleItemSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_module_items
    def list_module_items(self, course_id, module_id, **kwargs):
        """
        List module items
        List the items in a module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_module_items_with_http_info(course_id, module_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param list[str] include: If included, will return additional details specific to the content associated with each item. Refer to the {api:Modules:Module%20Item Module Item specification} for more details. Includes standard lock information for each item.
        :param str search_term: The partial title of the items to match and return.
        :param str student_id: Returns module completion information for the student with this id.
        :return: list[ModuleItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'include', 'search_term', 'student_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_module_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_module_items`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `list_module_items`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'student_id' in params:
            query_params['student_id'] = params['student_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ModuleItem]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_modules
    def list_modules(self, course_id, **kwargs):
        """
        List modules
        List the modules in a course

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_modules_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param list[str] include: - \"items\": Return module items inline if possible. This parameter suggests that Canvas return module items directly in the Module object JSON, to avoid having to make separate API requests for each module when enumerating modules and items. Canvas is free to omit 'items' for any particular module if it deems them too numerous to return inline. Callers must be prepared to use the {api:ContextModuleItemsApiController#index List Module Items API} if items are not returned. - \"content_details\": Requires include['items']. Returns additional details with module items specific to their associated content items. Includes standard lock information for each item.
        :param str search_term: The partial name of the modules (and module items, if include['items'] is specified) to match and return.
        :param str student_id: Returns module completion information for the student with this id.
        :return: list[Module]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'include', 'search_term', 'student_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_modules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_modules`")

        resource_path = '/v1/courses/{course_id}/modules'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'student_id' in params:
            query_params['student_id'] = params['student_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Module]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_module_item_read
    def mark_module_item_read(self, course_id, module_id, id, **kwargs):
        """
        Mark module item read
        Fulfills \"must view\" requirement for a module item. It is generally not necessary to do this explicitly, but it is provided for applications that need to access external content directly (bypassing the html_url redirect that normally allows Canvas to fulfill \"must view\" requirements).  This endpoint cannot be used to complete requirements on locked or unpublished module items.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_module_item_read_with_http_info(course_id, module_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_module_item_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_module_item_read`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `mark_module_item_read`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `mark_module_item_read`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items/{id}/mark_read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: re_lock_module_progressions
    def re_lock_module_progressions(self, course_id, id, **kwargs):
        """
        Re-lock module progressions
        Resets module progressions to their default locked state and recalculates them based on the current requirements.  Adding progression requirements to an active course will not lock students out of modules they have already unlocked unless this action is called.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.re_lock_module_progressions_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: Module
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method re_lock_module_progressions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `re_lock_module_progressions`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `re_lock_module_progressions`")

        resource_path = '/v1/courses/{course_id}/modules/{id}/relock'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Module',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_module
    def show_module(self, course_id, id, **kwargs):
        """
        Show module
        Get information about a single module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_module_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: - \"items\": Return module items inline if possible. This parameter suggests that Canvas return module items directly in the Module object JSON, to avoid having to make separate API requests for each module when enumerating modules and items. Canvas is free to omit 'items' for any particular module if it deems them too numerous to return inline. Callers must be prepared to use the {api:ContextModuleItemsApiController#index List Module Items API} if items are not returned. - \"content_details\": Requires include['items']. Returns additional details with module items specific to their associated content items. Includes standard lock information for each item.
        :param str student_id: Returns module completion information for the student with this id.
        :return: Module
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'include', 'student_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_module" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_module`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_module`")

        resource_path = '/v1/courses/{course_id}/modules/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'student_id' in params:
            query_params['student_id'] = params['student_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Module',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_module_item
    def show_module_item(self, course_id, module_id, id, **kwargs):
        """
        Show module item
        Get information about a single module item

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_module_item_with_http_info(course_id, module_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: If included, will return additional details specific to the content associated with this item. Refer to the {api:Modules:Module%20Item Module Item specification} for more details. Includes standard lock information for each item.
        :param str student_id: Returns module completion information for the student with this id.
        :return: ModuleItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'id', 'include', 'student_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_module_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_module_item`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `show_module_item`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_module_item`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'student_id' in params:
            query_params['student_id'] = params['student_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModuleItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_module
    def update_module(self, course_id, id, **kwargs):
        """
        Update a module
        Update and return an existing module

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_module_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str module_name: The name of the module
        :param Object module_unlock_at: The date the module will unlock
        :param int module_position: The position of the module in the course (1-based)
        :param bool module_require_sequential_progress: Whether module items must be unlocked in order
        :param list[str] module_prerequisite_module_ids: IDs of Modules that must be completed before this one is unlocked Prerequisite modules must precede this module (i.e. have a lower position value), otherwise they will be ignored
        :param bool module_publish_final_grade: Whether to publish the student's final grade for the course upon completion of this module.
        :param bool module_published: Whether the module is published and visible to students
        :return: Module
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'module_name', 'module_unlock_at', 'module_position', 'module_require_sequential_progress', 'module_prerequisite_module_ids', 'module_publish_final_grade', 'module_published']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_module" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_module`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_module`")

        resource_path = '/v1/courses/{course_id}/modules/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'module_name' in params:
            form_params.append(('module[name]', params['module_name']))
        if 'module_unlock_at' in params:
            form_params.append(('module[unlock_at]', params['module_unlock_at']))
        if 'module_position' in params:
            form_params.append(('module[position]', params['module_position']))
        if 'module_require_sequential_progress' in params:
            form_params.append(('module[require_sequential_progress]', params['module_require_sequential_progress']))
        if 'module_prerequisite_module_ids' in params:
            form_params.append(('module[prerequisite_module_ids]', params['module_prerequisite_module_ids']))
        if 'module_publish_final_grade' in params:
            form_params.append(('module[publish_final_grade]', params['module_publish_final_grade']))
        if 'module_published' in params:
            form_params.append(('module[published]', params['module_published']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Module',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_module_item
    def update_module_item(self, course_id, module_id, id, **kwargs):
        """
        Update a module item
        Update and return an existing module item

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_module_item_with_http_info(course_id, module_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str module_id: ID (required)
        :param str id: ID (required)
        :param str module_item_title: The name of the module item
        :param int module_item_position: The position of this item in the module (1-based)
        :param int module_item_indent: 0-based indent level; module items may be indented to show a hierarchy
        :param str module_item_external_url: External url that the item points to. Only applies to 'ExternalUrl' type.
        :param bool module_item_new_tab: Whether the external tool opens in a new tab. Only applies to 'ExternalTool' type.
        :param str module_item_completion_requirement_type: Completion requirement for this module item. \"must_view\": Applies to all item types \"must_contribute\": Only applies to \"Assignment\", \"Discussion\", and \"Page\" types \"must_submit\", \"min_score\": Only apply to \"Assignment\" and \"Quiz\" types Inapplicable types will be ignored
        :param int module_item_completion_requirement_min_score: Minimum score required to complete, Required for completion_requirement type 'min_score'.
        :param bool module_item_published: Whether the module item is published and visible to students.
        :param str module_item_module_id: Move this item to another module by specifying the target module id here. The target module must be in the same course.
        :return: ModuleItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'module_id', 'id', 'module_item_title', 'module_item_position', 'module_item_indent', 'module_item_external_url', 'module_item_new_tab', 'module_item_completion_requirement_type', 'module_item_completion_requirement_min_score', 'module_item_published', 'module_item_module_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_module_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_module_item`")
        # verify the required parameter 'module_id' is set
        if ('module_id' not in params) or (params['module_id'] is None):
            raise ValueError("Missing the required parameter `module_id` when calling `update_module_item`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_module_item`")

        resource_path = '/v1/courses/{course_id}/modules/{module_id}/items/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'module_id' in params:
            path_params['module_id'] = params['module_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'module_item_title' in params:
            form_params.append(('module_item[title]', params['module_item_title']))
        if 'module_item_position' in params:
            form_params.append(('module_item[position]', params['module_item_position']))
        if 'module_item_indent' in params:
            form_params.append(('module_item[indent]', params['module_item_indent']))
        if 'module_item_external_url' in params:
            form_params.append(('module_item[external_url]', params['module_item_external_url']))
        if 'module_item_new_tab' in params:
            form_params.append(('module_item[new_tab]', params['module_item_new_tab']))
        if 'module_item_completion_requirement_type' in params:
            form_params.append(('module_item[completion_requirement][type]', params['module_item_completion_requirement_type']))
        if 'module_item_completion_requirement_min_score' in params:
            form_params.append(('module_item[completion_requirement][min_score]', params['module_item_completion_requirement_min_score']))
        if 'module_item_published' in params:
            form_params.append(('module_item[published]', params['module_item_published']))
        if 'module_item_module_id' in params:
            form_params.append(('module_item[module_id]', params['module_item_module_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ModuleItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
