# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class UsageRights(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, legal_copyright=None, use_justification=None, license=None, license_name=None, message=None, file_ids=None):
        """
        UsageRights - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'legal_copyright': 'str',
            'use_justification': 'str',
            'license': 'str',
            'license_name': 'str',
            'message': 'str',
            'file_ids': 'list[int]'
        }

        self.attribute_map = {
            'legal_copyright': 'legal_copyright',
            'use_justification': 'use_justification',
            'license': 'license',
            'license_name': 'license_name',
            'message': 'message',
            'file_ids': 'file_ids'
        }

        self._legal_copyright = legal_copyright
        self._use_justification = use_justification
        self._license = license
        self._license_name = license_name
        self._message = message
        self._file_ids = file_ids

    @property
    def legal_copyright(self):
        """
        Gets the legal_copyright of this UsageRights.
        Copyright line for the file

        :return: The legal_copyright of this UsageRights.
        :rtype: str
        """
        return self._legal_copyright

    @legal_copyright.setter
    def legal_copyright(self, legal_copyright):
        """
        Sets the legal_copyright of this UsageRights.
        Copyright line for the file

        :param legal_copyright: The legal_copyright of this UsageRights.
        :type: str
        """

        self._legal_copyright = legal_copyright

    @property
    def use_justification(self):
        """
        Gets the use_justification of this UsageRights.
        Justification for using the file in a Canvas course. Valid values are 'own_copyright', 'public_domain', 'used_by_permission', 'fair_use', 'creative_commons'

        :return: The use_justification of this UsageRights.
        :rtype: str
        """
        return self._use_justification

    @use_justification.setter
    def use_justification(self, use_justification):
        """
        Sets the use_justification of this UsageRights.
        Justification for using the file in a Canvas course. Valid values are 'own_copyright', 'public_domain', 'used_by_permission', 'fair_use', 'creative_commons'

        :param use_justification: The use_justification of this UsageRights.
        :type: str
        """

        self._use_justification = use_justification

    @property
    def license(self):
        """
        Gets the license of this UsageRights.
        License identifier for the file.

        :return: The license of this UsageRights.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this UsageRights.
        License identifier for the file.

        :param license: The license of this UsageRights.
        :type: str
        """

        self._license = license

    @property
    def license_name(self):
        """
        Gets the license_name of this UsageRights.
        Readable license name

        :return: The license_name of this UsageRights.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this UsageRights.
        Readable license name

        :param license_name: The license_name of this UsageRights.
        :type: str
        """

        self._license_name = license_name

    @property
    def message(self):
        """
        Gets the message of this UsageRights.
        Explanation of the action performed

        :return: The message of this UsageRights.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this UsageRights.
        Explanation of the action performed

        :param message: The message of this UsageRights.
        :type: str
        """

        self._message = message

    @property
    def file_ids(self):
        """
        Gets the file_ids of this UsageRights.
        List of ids of files that were updated

        :return: The file_ids of this UsageRights.
        :rtype: list[int]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """
        Sets the file_ids of this UsageRights.
        List of ids of files that were updated

        :param file_ids: The file_ids of this UsageRights.
        :type: list[int]
        """

        self._file_ids = file_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
