# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class EnrollmentsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: conclude_enrollment
    def conclude_enrollment(self, course_id, id, **kwargs):
        """
        Conclude an enrollment
        Delete or conclude an enrollment.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.conclude_enrollment_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str task: The action to take on the enrollment.
        :return: Enrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'task']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method conclude_enrollment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `conclude_enrollment`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `conclude_enrollment`")

        resource_path = '/v1/courses/{course_id}/enrollments/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'task' in params:
            query_params['task'] = params['task']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Enrollment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: enroll_user_courses
    def enroll_user_courses(self, course_id, enrollment_user_id, enrollment_type, **kwargs):
        """
        Enroll a user
        Create a new user enrollment for a course or section.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enroll_user_courses_with_http_info(course_id, enrollment_user_id, enrollment_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str enrollment_user_id: The ID of the user to be enrolled in the course. (required)
        :param str enrollment_type: Enroll the user as a student, teacher, TA, observer, or designer. If no value is given, the type will be inferred by enrollment[role] if supplied, otherwise 'StudentEnrollment' will be used. (required)
        :param Object enrollment_role: Assigns a custom course-level role to the user.
        :param int enrollment_role_id: Assigns a custom course-level role to the user.
        :param str enrollment_enrollment_state: If set to 'active,' student will be immediately enrolled in the course. Otherwise they will be required to accept a course invitation. Default is 'invited.'
        :param int enrollment_course_section_id: The ID of the course section to enroll the student in. If the section-specific URL is used, this argument is redundant and will be ignored.
        :param bool enrollment_limit_privileges_to_course_section: If a teacher or TA enrollment, teacher/TA will be restricted to the section given by course_section_id.
        :param bool enrollment_notify: If true, a notification will be sent to the enrolled user. Notifications are not sent by default.
        :param str enrollment_self_enrollment_code: If the current user is not allowed to manage enrollments in this course, but the course allows self-enrollment, the user can self- enroll as a student in the default section by passing in a valid code. When self-enrolling, the user_id must be 'self'. The enrollment_state will be set to 'active' and all other arguments will be ignored.
        :param bool enrollment_self_enrolled: If true, marks the enrollment as a self-enrollment, which gives students the ability to drop the course if desired. Defaults to false.
        :return: Enrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'enrollment_user_id', 'enrollment_type', 'enrollment_role', 'enrollment_role_id', 'enrollment_enrollment_state', 'enrollment_course_section_id', 'enrollment_limit_privileges_to_course_section', 'enrollment_notify', 'enrollment_self_enrollment_code', 'enrollment_self_enrolled']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enroll_user_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `enroll_user_courses`")
        # verify the required parameter 'enrollment_user_id' is set
        if ('enrollment_user_id' not in params) or (params['enrollment_user_id'] is None):
            raise ValueError("Missing the required parameter `enrollment_user_id` when calling `enroll_user_courses`")
        # verify the required parameter 'enrollment_type' is set
        if ('enrollment_type' not in params) or (params['enrollment_type'] is None):
            raise ValueError("Missing the required parameter `enrollment_type` when calling `enroll_user_courses`")

        resource_path = '/v1/courses/{course_id}/enrollments'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'enrollment_user_id' in params:
            form_params.append(('enrollment[user_id]', params['enrollment_user_id']))
        if 'enrollment_type' in params:
            form_params.append(('enrollment[type]', params['enrollment_type']))
        if 'enrollment_role' in params:
            form_params.append(('enrollment[role]', params['enrollment_role']))
        if 'enrollment_role_id' in params:
            form_params.append(('enrollment[role_id]', params['enrollment_role_id']))
        if 'enrollment_enrollment_state' in params:
            form_params.append(('enrollment[enrollment_state]', params['enrollment_enrollment_state']))
        if 'enrollment_course_section_id' in params:
            form_params.append(('enrollment[course_section_id]', params['enrollment_course_section_id']))
        if 'enrollment_limit_privileges_to_course_section' in params:
            form_params.append(('enrollment[limit_privileges_to_course_section]', params['enrollment_limit_privileges_to_course_section']))
        if 'enrollment_notify' in params:
            form_params.append(('enrollment[notify]', params['enrollment_notify']))
        if 'enrollment_self_enrollment_code' in params:
            form_params.append(('enrollment[self_enrollment_code]', params['enrollment_self_enrollment_code']))
        if 'enrollment_self_enrolled' in params:
            form_params.append(('enrollment[self_enrolled]', params['enrollment_self_enrolled']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Enrollment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: enroll_user_sections
    def enroll_user_sections(self, section_id, enrollment_user_id, enrollment_type, **kwargs):
        """
        Enroll a user
        Create a new user enrollment for a course or section.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enroll_user_sections_with_http_info(section_id, enrollment_user_id, enrollment_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param str enrollment_user_id: The ID of the user to be enrolled in the course. (required)
        :param str enrollment_type: Enroll the user as a student, teacher, TA, observer, or designer. If no value is given, the type will be inferred by enrollment[role] if supplied, otherwise 'StudentEnrollment' will be used. (required)
        :param Object enrollment_role: Assigns a custom course-level role to the user.
        :param int enrollment_role_id: Assigns a custom course-level role to the user.
        :param str enrollment_enrollment_state: If set to 'active,' student will be immediately enrolled in the course. Otherwise they will be required to accept a course invitation. Default is 'invited.'
        :param int enrollment_course_section_id: The ID of the course section to enroll the student in. If the section-specific URL is used, this argument is redundant and will be ignored.
        :param bool enrollment_limit_privileges_to_course_section: If a teacher or TA enrollment, teacher/TA will be restricted to the section given by course_section_id.
        :param bool enrollment_notify: If true, a notification will be sent to the enrolled user. Notifications are not sent by default.
        :param str enrollment_self_enrollment_code: If the current user is not allowed to manage enrollments in this course, but the course allows self-enrollment, the user can self- enroll as a student in the default section by passing in a valid code. When self-enrolling, the user_id must be 'self'. The enrollment_state will be set to 'active' and all other arguments will be ignored.
        :param bool enrollment_self_enrolled: If true, marks the enrollment as a self-enrollment, which gives students the ability to drop the course if desired. Defaults to false.
        :return: Enrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'enrollment_user_id', 'enrollment_type', 'enrollment_role', 'enrollment_role_id', 'enrollment_enrollment_state', 'enrollment_course_section_id', 'enrollment_limit_privileges_to_course_section', 'enrollment_notify', 'enrollment_self_enrollment_code', 'enrollment_self_enrolled']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enroll_user_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `enroll_user_sections`")
        # verify the required parameter 'enrollment_user_id' is set
        if ('enrollment_user_id' not in params) or (params['enrollment_user_id'] is None):
            raise ValueError("Missing the required parameter `enrollment_user_id` when calling `enroll_user_sections`")
        # verify the required parameter 'enrollment_type' is set
        if ('enrollment_type' not in params) or (params['enrollment_type'] is None):
            raise ValueError("Missing the required parameter `enrollment_type` when calling `enroll_user_sections`")

        resource_path = '/v1/sections/{section_id}/enrollments'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'enrollment_user_id' in params:
            form_params.append(('enrollment[user_id]', params['enrollment_user_id']))
        if 'enrollment_type' in params:
            form_params.append(('enrollment[type]', params['enrollment_type']))
        if 'enrollment_role' in params:
            form_params.append(('enrollment[role]', params['enrollment_role']))
        if 'enrollment_role_id' in params:
            form_params.append(('enrollment[role_id]', params['enrollment_role_id']))
        if 'enrollment_enrollment_state' in params:
            form_params.append(('enrollment[enrollment_state]', params['enrollment_enrollment_state']))
        if 'enrollment_course_section_id' in params:
            form_params.append(('enrollment[course_section_id]', params['enrollment_course_section_id']))
        if 'enrollment_limit_privileges_to_course_section' in params:
            form_params.append(('enrollment[limit_privileges_to_course_section]', params['enrollment_limit_privileges_to_course_section']))
        if 'enrollment_notify' in params:
            form_params.append(('enrollment[notify]', params['enrollment_notify']))
        if 'enrollment_self_enrollment_code' in params:
            form_params.append(('enrollment[self_enrollment_code]', params['enrollment_self_enrollment_code']))
        if 'enrollment_self_enrolled' in params:
            form_params.append(('enrollment[self_enrolled]', params['enrollment_self_enrolled']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Enrollment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: enrollment_by_id
    def enrollment_by_id(self, account_id, id, **kwargs):
        """
        Enrollment by ID
        Get an Enrollment object by Enrollment ID

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enrollment_by_id_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param int id: The ID of the enrollment object (required)
        :return: Enrollment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enrollment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `enrollment_by_id`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `enrollment_by_id`")

        resource_path = '/v1/accounts/{account_id}/enrollments/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Enrollment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_enrollments_courses
    def list_enrollments_courses(self, course_id, **kwargs):
        """
        List enrollments
        Depending on the URL given, return either (1) all of the enrollments in a course, (2) all of the enrollments in a section or (3) all of a user's enrollments. This includes student, teacher, TA, and observer enrollments.  If a user has multiple enrollments in a context (e.g. as a teacher and a student or in multiple course sections), each enrollment will be listed separately.  note: Currently, only an admin user can return other users' enrollments. A user can, however, return his/her own enrollments.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_enrollments_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param list[str] type: A list of enrollment types to return. Accepted values are 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'DesignerEnrollment', and 'ObserverEnrollment.' If omitted, all enrollment types are returned. This argument is ignored if `role` is given.
        :param list[str] role: A list of enrollment roles to return. Accepted values include course-level roles created by the {api:RoleOverridesController#add_role Add Role API} as well as the base enrollment types accepted by the `type` argument above.
        :param list[str] state: Filter by enrollment state. If omitted, 'active' and 'invited' enrollments are returned. When querying a user's enrollments (either via user_id argument or via user enrollments endpoint), the following additional synthetic states are supported: \"current_and_invited\"|\"current_and_future\"|\"current_and_concluded\"
        :param str user_id: Filter by user_id (only valid for course or section enrollment queries). If set to the current user's id, this is a way to determine if the user has any enrollments in the course or section, independent of whether the user has permission to view other people on the roster.
        :return: list[Enrollment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'type', 'role', 'state', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_enrollments_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_enrollments_courses`")

        resource_path = '/v1/courses/{course_id}/enrollments'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'role' in params:
            query_params['role'] = params['role']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Enrollment]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_enrollments_sections
    def list_enrollments_sections(self, section_id, **kwargs):
        """
        List enrollments
        Depending on the URL given, return either (1) all of the enrollments in a course, (2) all of the enrollments in a section or (3) all of a user's enrollments. This includes student, teacher, TA, and observer enrollments.  If a user has multiple enrollments in a context (e.g. as a teacher and a student or in multiple course sections), each enrollment will be listed separately.  note: Currently, only an admin user can return other users' enrollments. A user can, however, return his/her own enrollments.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_enrollments_sections_with_http_info(section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str section_id: ID (required)
        :param list[str] type: A list of enrollment types to return. Accepted values are 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'DesignerEnrollment', and 'ObserverEnrollment.' If omitted, all enrollment types are returned. This argument is ignored if `role` is given.
        :param list[str] role: A list of enrollment roles to return. Accepted values include course-level roles created by the {api:RoleOverridesController#add_role Add Role API} as well as the base enrollment types accepted by the `type` argument above.
        :param list[str] state: Filter by enrollment state. If omitted, 'active' and 'invited' enrollments are returned. When querying a user's enrollments (either via user_id argument or via user enrollments endpoint), the following additional synthetic states are supported: \"current_and_invited\"|\"current_and_future\"|\"current_and_concluded\"
        :param str user_id: Filter by user_id (only valid for course or section enrollment queries). If set to the current user's id, this is a way to determine if the user has any enrollments in the course or section, independent of whether the user has permission to view other people on the roster.
        :return: list[Enrollment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_id', 'type', 'role', 'state', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_enrollments_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_id' is set
        if ('section_id' not in params) or (params['section_id'] is None):
            raise ValueError("Missing the required parameter `section_id` when calling `list_enrollments_sections`")

        resource_path = '/v1/sections/{section_id}/enrollments'.replace('{format}', 'json')
        path_params = {}
        if 'section_id' in params:
            path_params['section_id'] = params['section_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'role' in params:
            query_params['role'] = params['role']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Enrollment]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_enrollments_users
    def list_enrollments_users(self, user_id, **kwargs):
        """
        List enrollments
        Depending on the URL given, return either (1) all of the enrollments in a course, (2) all of the enrollments in a section or (3) all of a user's enrollments. This includes student, teacher, TA, and observer enrollments.  If a user has multiple enrollments in a context (e.g. as a teacher and a student or in multiple course sections), each enrollment will be listed separately.  note: Currently, only an admin user can return other users' enrollments. A user can, however, return his/her own enrollments.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_enrollments_users_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: Filter by user_id (only valid for course or section enrollment queries). If set to the current user's id, this is a way to determine if the user has any enrollments in the course or section, independent of whether the user has permission to view other people on the roster. (required)
        :param list[str] type: A list of enrollment types to return. Accepted values are 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'DesignerEnrollment', and 'ObserverEnrollment.' If omitted, all enrollment types are returned. This argument is ignored if `role` is given.
        :param list[str] role: A list of enrollment roles to return. Accepted values include course-level roles created by the {api:RoleOverridesController#add_role Add Role API} as well as the base enrollment types accepted by the `type` argument above.
        :param list[str] state: Filter by enrollment state. If omitted, 'active' and 'invited' enrollments are returned. When querying a user's enrollments (either via user_id argument or via user enrollments endpoint), the following additional synthetic states are supported: \"current_and_invited\"|\"current_and_future\"|\"current_and_concluded\"
        :return: list[Enrollment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'type', 'role', 'state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_enrollments_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_enrollments_users`")

        resource_path = '/v1/users/{user_id}/enrollments'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'role' in params:
            query_params['role'] = params['role']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Enrollment]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
