# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class EnrollmentTerm(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, sis_term_id=None, name=None, start_at=None, end_at=None, workflow_state=None):
        """
        EnrollmentTerm - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'sis_term_id': 'str',
            'name': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'workflow_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'sis_term_id': 'sis_term_id',
            'name': 'name',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'workflow_state': 'workflow_state'
        }

        self._id = id
        self._sis_term_id = sis_term_id
        self._name = name
        self._start_at = start_at
        self._end_at = end_at
        self._workflow_state = workflow_state

    @property
    def id(self):
        """
        Gets the id of this EnrollmentTerm.
        The unique identifier for the enrollment term.

        :return: The id of this EnrollmentTerm.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EnrollmentTerm.
        The unique identifier for the enrollment term.

        :param id: The id of this EnrollmentTerm.
        :type: int
        """

        self._id = id

    @property
    def sis_term_id(self):
        """
        Gets the sis_term_id of this EnrollmentTerm.
        The SIS id of the term. Only included if the user has permission to view SIS information.

        :return: The sis_term_id of this EnrollmentTerm.
        :rtype: str
        """
        return self._sis_term_id

    @sis_term_id.setter
    def sis_term_id(self, sis_term_id):
        """
        Sets the sis_term_id of this EnrollmentTerm.
        The SIS id of the term. Only included if the user has permission to view SIS information.

        :param sis_term_id: The sis_term_id of this EnrollmentTerm.
        :type: str
        """

        self._sis_term_id = sis_term_id

    @property
    def name(self):
        """
        Gets the name of this EnrollmentTerm.
        The name of the term.

        :return: The name of this EnrollmentTerm.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EnrollmentTerm.
        The name of the term.

        :param name: The name of this EnrollmentTerm.
        :type: str
        """

        self._name = name

    @property
    def start_at(self):
        """
        Gets the start_at of this EnrollmentTerm.
        The datetime of the start of the term.

        :return: The start_at of this EnrollmentTerm.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this EnrollmentTerm.
        The datetime of the start of the term.

        :param start_at: The start_at of this EnrollmentTerm.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this EnrollmentTerm.
        The datetime of the end of the term.

        :return: The end_at of this EnrollmentTerm.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this EnrollmentTerm.
        The datetime of the end of the term.

        :param end_at: The end_at of this EnrollmentTerm.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this EnrollmentTerm.
        The state of the term. Can be 'active' or 'deleted'.

        :return: The workflow_state of this EnrollmentTerm.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this EnrollmentTerm.
        The state of the term. Can be 'active' or 'deleted'.

        :param workflow_state: The workflow_state of this EnrollmentTerm.
        :type: str
        """

        self._workflow_state = workflow_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
