# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class DiscussiontopicsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_new_discussion_topic_courses
    def create_new_discussion_topic_courses(self, course_id, **kwargs):
        """
        Create a new discussion topic
        Create an new discussion topic for the course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_new_discussion_topic_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str title: no description
        :param str message: no description
        :param str discussion_type: The type of discussion. Defaults to side_comment if not value is given. Accepted values are 'side_comment', for discussions that only allow one level of nested comments, and 'threaded' for fully threaded discussions.
        :param bool published: Whether this topic is published (true) or draft state (false). Only teachers and TAs have the ability to create draft state topics.
        :param Object delayed_post_at: If a timestamp is given, the topic will not be published until that time.
        :param Object lock_at: If a timestamp is given, the topic will be scheduled to lock at the provided timestamp. If the timestamp is in the past, the topic will be locked.
        :param bool podcast_enabled: If true, the topic will have an associated podcast feed.
        :param bool podcast_has_student_posts: If true, the podcast will include posts from students as well. Implies podcast_enabled.
        :param bool require_initial_post: If true then a user may not respond to other replies until that user has made an initial reply. Defaults to false.
        :param Object assignment: To create an assignment discussion, pass the assignment parameters as a sub-object. See the {api:AssignmentsApiController#create Create an Assignment API} for the available parameters. The name parameter will be ignored, as it's taken from the discussion title. If you want to make a discussion that was an assignment NOT an assignment, pass set_assignment = false as part of the assignment object
        :param bool is_announcement: If true, this topic is an announcement. It will appear in the announcement's section rather than the discussions section. This requires announcment-posting permissions.
        :param str position_after: By default, discussions are sorted chronologically by creation date, you can pass the id of another topic to have this one show up after the other when they are listed.
        :param int group_category_id: If present, the topic will become a group discussion assigned to the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'title', 'message', 'discussion_type', 'published', 'delayed_post_at', 'lock_at', 'podcast_enabled', 'podcast_has_student_posts', 'require_initial_post', 'assignment', 'is_announcement', 'position_after', 'group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_discussion_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_new_discussion_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'discussion_type' in params:
            form_params.append(('discussion_type', params['discussion_type']))
        if 'published' in params:
            form_params.append(('published', params['published']))
        if 'delayed_post_at' in params:
            form_params.append(('delayed_post_at', params['delayed_post_at']))
        if 'lock_at' in params:
            form_params.append(('lock_at', params['lock_at']))
        if 'podcast_enabled' in params:
            form_params.append(('podcast_enabled', params['podcast_enabled']))
        if 'podcast_has_student_posts' in params:
            form_params.append(('podcast_has_student_posts', params['podcast_has_student_posts']))
        if 'require_initial_post' in params:
            form_params.append(('require_initial_post', params['require_initial_post']))
        if 'assignment' in params:
            form_params.append(('assignment', params['assignment']))
        if 'is_announcement' in params:
            form_params.append(('is_announcement', params['is_announcement']))
        if 'position_after' in params:
            form_params.append(('position_after', params['position_after']))
        if 'group_category_id' in params:
            form_params.append(('group_category_id', params['group_category_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_new_discussion_topic_groups
    def create_new_discussion_topic_groups(self, group_id, **kwargs):
        """
        Create a new discussion topic
        Create an new discussion topic for the course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_new_discussion_topic_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str title: no description
        :param str message: no description
        :param str discussion_type: The type of discussion. Defaults to side_comment if not value is given. Accepted values are 'side_comment', for discussions that only allow one level of nested comments, and 'threaded' for fully threaded discussions.
        :param bool published: Whether this topic is published (true) or draft state (false). Only teachers and TAs have the ability to create draft state topics.
        :param Object delayed_post_at: If a timestamp is given, the topic will not be published until that time.
        :param Object lock_at: If a timestamp is given, the topic will be scheduled to lock at the provided timestamp. If the timestamp is in the past, the topic will be locked.
        :param bool podcast_enabled: If true, the topic will have an associated podcast feed.
        :param bool podcast_has_student_posts: If true, the podcast will include posts from students as well. Implies podcast_enabled.
        :param bool require_initial_post: If true then a user may not respond to other replies until that user has made an initial reply. Defaults to false.
        :param Object assignment: To create an assignment discussion, pass the assignment parameters as a sub-object. See the {api:AssignmentsApiController#create Create an Assignment API} for the available parameters. The name parameter will be ignored, as it's taken from the discussion title. If you want to make a discussion that was an assignment NOT an assignment, pass set_assignment = false as part of the assignment object
        :param bool is_announcement: If true, this topic is an announcement. It will appear in the announcement's section rather than the discussions section. This requires announcment-posting permissions.
        :param str position_after: By default, discussions are sorted chronologically by creation date, you can pass the id of another topic to have this one show up after the other when they are listed.
        :param int group_category_id: If present, the topic will become a group discussion assigned to the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'title', 'message', 'discussion_type', 'published', 'delayed_post_at', 'lock_at', 'podcast_enabled', 'podcast_has_student_posts', 'require_initial_post', 'assignment', 'is_announcement', 'position_after', 'group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_discussion_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_new_discussion_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'discussion_type' in params:
            form_params.append(('discussion_type', params['discussion_type']))
        if 'published' in params:
            form_params.append(('published', params['published']))
        if 'delayed_post_at' in params:
            form_params.append(('delayed_post_at', params['delayed_post_at']))
        if 'lock_at' in params:
            form_params.append(('lock_at', params['lock_at']))
        if 'podcast_enabled' in params:
            form_params.append(('podcast_enabled', params['podcast_enabled']))
        if 'podcast_has_student_posts' in params:
            form_params.append(('podcast_has_student_posts', params['podcast_has_student_posts']))
        if 'require_initial_post' in params:
            form_params.append(('require_initial_post', params['require_initial_post']))
        if 'assignment' in params:
            form_params.append(('assignment', params['assignment']))
        if 'is_announcement' in params:
            form_params.append(('is_announcement', params['is_announcement']))
        if 'position_after' in params:
            form_params.append(('position_after', params['position_after']))
        if 'group_category_id' in params:
            form_params.append(('group_category_id', params['group_category_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_entry_courses
    def delete_entry_courses(self, course_id, topic_id, id, **kwargs):
        """
        Delete an entry
        Delete a discussion entry.  The entry must have been created by the current user, or the current user must have admin rights to the discussion. If the delete is not allowed, a 401 will be returned.  The discussion will be marked deleted, and the user_id and message will be cleared out.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_entry_courses_with_http_info(course_id, topic_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entry_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_entry_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_entry_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_entry_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_entry_groups
    def delete_entry_groups(self, group_id, topic_id, id, **kwargs):
        """
        Delete an entry
        Delete a discussion entry.  The entry must have been created by the current user, or the current user must have admin rights to the discussion. If the delete is not allowed, a 401 will be returned.  The discussion will be marked deleted, and the user_id and message will be cleared out.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_entry_groups_with_http_info(group_id, topic_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entry_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `delete_entry_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_entry_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_entry_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_topic_courses
    def delete_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Delete a topic
        Deletes the discussion topic. This will also delete the assignment, if it's an assignment discussion.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_topic_groups
    def delete_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Delete a topic
        Deletes the discussion topic. This will also delete the assignment, if it's an assignment discussion.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `delete_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_full_topic_courses
    def get_full_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Get the full topic
        Return a cached structure of the discussion topic, containing all entries, their authors, and their message bodies.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  In some rare situations, this cached structure may not be available yet. In that case, the server will respond with a 503 error, and the caller should try again soon.  The response is an object containing the following keys: * \"participants\": A list of summary information on users who have posted to   the discussion. Each value is an object containing their id, display_name,   and avatar_url. * \"unread_entries\": A list of entry ids that are unread by the current   user. this implies that any entry not in this list is read. * \"forced_entries\": A list of entry ids that have forced_read_state set to   true. This flag is meant to indicate the entry's read_state has been    manually set to 'unread' by the user, so the entry should not be   automatically marked as read. * \"view\": A threaded view of all the entries in the discussion, containing   the id, user_id, and message. * \"new_entries\": Because this view is eventually consistent, it's possible   that newly created or updated entries won't yet be reflected in the view.   If the application wants to also get a flat list of all entries not yet   reflected in the view, pass include_new_entries=1 to the request and this   array of entries will be returned. These entries are returned in a flat   array, in ascending created_at order.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_full_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_full_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_full_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/view'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_full_topic_groups
    def get_full_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Get the full topic
        Return a cached structure of the discussion topic, containing all entries, their authors, and their message bodies.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  In some rare situations, this cached structure may not be available yet. In that case, the server will respond with a 503 error, and the caller should try again soon.  The response is an object containing the following keys: * \"participants\": A list of summary information on users who have posted to   the discussion. Each value is an object containing their id, display_name,   and avatar_url. * \"unread_entries\": A list of entry ids that are unread by the current   user. this implies that any entry not in this list is read. * \"forced_entries\": A list of entry ids that have forced_read_state set to   true. This flag is meant to indicate the entry's read_state has been    manually set to 'unread' by the user, so the entry should not be   automatically marked as read. * \"view\": A threaded view of all the entries in the discussion, containing   the id, user_id, and message. * \"new_entries\": Because this view is eventually consistent, it's possible   that newly created or updated entries won't yet be reflected in the view.   If the application wants to also get a flat list of all entries not yet   reflected in the view, pass include_new_entries=1 to the request and this   array of entries will be returned. These entries are returned in a flat   array, in ascending created_at order.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_full_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_full_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_full_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/view'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_topic_courses
    def get_single_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Get a single topic
        Returns data on an individual discussion topic. See the List action for the response formatting.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_single_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_topic_groups
    def get_single_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Get a single topic
        Returns data on an individual discussion topic. See the List action for the response formatting.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_single_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_single_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_discussion_topics_courses
    def list_discussion_topics_courses(self, course_id, **kwargs):
        """
        List discussion topics
        Returns the paginated list of discussion topics for this course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_discussion_topics_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str order_by: Determines the order of the discussion topic list. Defaults to \"position\".
        :param str scope: Only return discussion topics in the given state(s). Defaults to including all topics. Filtering is done after pagination, so pages may be smaller than requested if topics are filtered. Can pass multiple states as comma separated string.
        :param bool only_announcements: Return announcements instead of discussion topics. Defaults to false
        :param str search_term: The partial title of the discussion topics to match and return.
        :return: list[DiscussionTopic]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'order_by', 'scope', 'only_announcements', 'search_term']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_discussion_topics_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_discussion_topics_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'scope' in params:
            query_params['scope'] = params['scope']
        if 'only_announcements' in params:
            query_params['only_announcements'] = params['only_announcements']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DiscussionTopic]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_discussion_topics_groups
    def list_discussion_topics_groups(self, group_id, **kwargs):
        """
        List discussion topics
        Returns the paginated list of discussion topics for this course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_discussion_topics_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str order_by: Determines the order of the discussion topic list. Defaults to \"position\".
        :param str scope: Only return discussion topics in the given state(s). Defaults to including all topics. Filtering is done after pagination, so pages may be smaller than requested if topics are filtered. Can pass multiple states as comma separated string.
        :param bool only_announcements: Return announcements instead of discussion topics. Defaults to false
        :param str search_term: The partial title of the discussion topics to match and return.
        :return: list[DiscussionTopic]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'order_by', 'scope', 'only_announcements', 'search_term']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_discussion_topics_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_discussion_topics_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'scope' in params:
            query_params['scope'] = params['scope']
        if 'only_announcements' in params:
            query_params['only_announcements'] = params['only_announcements']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DiscussionTopic]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_entries_courses
    def list_entries_courses(self, course_id, topic_id, **kwargs):
        """
        List entries
        Retrieve a paginated list of discussion entries, given a list of ids.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_entries_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param list[str] ids: A list of entry ids to retrieve. Entries will be returned in id order, smallest id first.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_entries_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_entries_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_entries_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entry_list'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_entries_groups
    def list_entries_groups(self, group_id, topic_id, **kwargs):
        """
        List entries
        Retrieve a paginated list of discussion entries, given a list of ids.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_entries_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param list[str] ids: A list of entry ids to retrieve. Entries will be returned in id order, smallest id first.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_entries_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_entries_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_entries_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entry_list'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_entry_replies_courses
    def list_entry_replies_courses(self, course_id, topic_id, entry_id, **kwargs):
        """
        List entry replies
        Retrieve the (paginated) replies to a top-level entry in a discussion topic.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  Ordering of returned entries is newest-first by creation timestamp.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_entry_replies_courses_with_http_info(course_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'entry_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_entry_replies_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_entry_replies_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_entry_replies_courses`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_entry_replies_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{entry_id}/replies'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_entry_replies_groups
    def list_entry_replies_groups(self, group_id, topic_id, entry_id, **kwargs):
        """
        List entry replies
        Retrieve the (paginated) replies to a top-level entry in a discussion topic.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  Ordering of returned entries is newest-first by creation timestamp.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_entry_replies_groups_with_http_info(group_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'entry_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_entry_replies_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_entry_replies_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_entry_replies_groups`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `list_entry_replies_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{entry_id}/replies'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_topic_entries_courses
    def list_topic_entries_courses(self, course_id, topic_id, **kwargs):
        """
        List topic entries
        Retrieve the (paginated) top-level entries in a discussion topic.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  Will include the 10 most recent replies, if any, for each entry returned.  If the topic is a root topic with children corresponding to groups of a group assignment, entries from those subtopics for which the user belongs to the corresponding group will be returned.  Ordering of returned entries is newest-first by posting timestamp (reply activity is ignored).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_topic_entries_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_topic_entries_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_topic_entries_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_topic_entries_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_topic_entries_groups
    def list_topic_entries_groups(self, group_id, topic_id, **kwargs):
        """
        List topic entries
        Retrieve the (paginated) top-level entries in a discussion topic.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.  Will include the 10 most recent replies, if any, for each entry returned.  If the topic is a root topic with children corresponding to groups of a group assignment, entries from those subtopics for which the user belongs to the corresponding group will be returned.  Ordering of returned entries is newest-first by posting timestamp (reply activity is ignored).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_topic_entries_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_topic_entries_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_topic_entries_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `list_topic_entries_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_all_entries_as_read_courses
    def mark_all_entries_as_read_courses(self, course_id, topic_id, **kwargs):
        """
        Mark all entries as read
        Mark the discussion topic and all its entries as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_all_entries_as_read_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param bool forced_read_state: A boolean value to set all of the entries' forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_all_entries_as_read_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_all_entries_as_read_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_all_entries_as_read_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/read_all'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'forced_read_state' in params:
            form_params.append(('forced_read_state', params['forced_read_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_all_entries_as_read_groups
    def mark_all_entries_as_read_groups(self, group_id, topic_id, **kwargs):
        """
        Mark all entries as read
        Mark the discussion topic and all its entries as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_all_entries_as_read_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param bool forced_read_state: A boolean value to set all of the entries' forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_all_entries_as_read_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_all_entries_as_read_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_all_entries_as_read_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/read_all'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'forced_read_state' in params:
            form_params.append(('forced_read_state', params['forced_read_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_all_entries_as_unread_courses
    def mark_all_entries_as_unread_courses(self, course_id, topic_id, **kwargs):
        """
        Mark all entries as unread
        Mark the discussion topic and all its entries as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_all_entries_as_unread_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param bool forced_read_state: A boolean value to set all of the entries' forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_all_entries_as_unread_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_all_entries_as_unread_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_all_entries_as_unread_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/read_all'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'forced_read_state' in params:
            query_params['forced_read_state'] = params['forced_read_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_all_entries_as_unread_groups
    def mark_all_entries_as_unread_groups(self, group_id, topic_id, **kwargs):
        """
        Mark all entries as unread
        Mark the discussion topic and all its entries as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_all_entries_as_unread_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param bool forced_read_state: A boolean value to set all of the entries' forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_all_entries_as_unread_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_all_entries_as_unread_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_all_entries_as_unread_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/read_all'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'forced_read_state' in params:
            query_params['forced_read_state'] = params['forced_read_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_entry_as_read_courses
    def mark_entry_as_read_courses(self, course_id, topic_id, entry_id, **kwargs):
        """
        Mark entry as read
        Mark a discussion entry as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_entry_as_read_courses_with_http_info(course_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param bool forced_read_state: A boolean value to set the entry's forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'entry_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_entry_as_read_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_entry_as_read_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_entry_as_read_courses`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `mark_entry_as_read_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{entry_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'forced_read_state' in params:
            form_params.append(('forced_read_state', params['forced_read_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_entry_as_read_groups
    def mark_entry_as_read_groups(self, group_id, topic_id, entry_id, **kwargs):
        """
        Mark entry as read
        Mark a discussion entry as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_entry_as_read_groups_with_http_info(group_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param bool forced_read_state: A boolean value to set the entry's forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'entry_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_entry_as_read_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_entry_as_read_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_entry_as_read_groups`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `mark_entry_as_read_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{entry_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'forced_read_state' in params:
            form_params.append(('forced_read_state', params['forced_read_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_entry_as_unread_courses
    def mark_entry_as_unread_courses(self, course_id, topic_id, entry_id, **kwargs):
        """
        Mark entry as unread
        Mark a discussion entry as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_entry_as_unread_courses_with_http_info(course_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param bool forced_read_state: A boolean value to set the entry's forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'entry_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_entry_as_unread_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_entry_as_unread_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_entry_as_unread_courses`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `mark_entry_as_unread_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{entry_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'forced_read_state' in params:
            query_params['forced_read_state'] = params['forced_read_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_entry_as_unread_groups
    def mark_entry_as_unread_groups(self, group_id, topic_id, entry_id, **kwargs):
        """
        Mark entry as unread
        Mark a discussion entry as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_entry_as_unread_groups_with_http_info(group_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param bool forced_read_state: A boolean value to set the entry's forced_read_state. No change is made if this argument is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'entry_id', 'forced_read_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_entry_as_unread_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_entry_as_unread_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_entry_as_unread_groups`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `mark_entry_as_unread_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{entry_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'forced_read_state' in params:
            query_params['forced_read_state'] = params['forced_read_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_topic_as_read_courses
    def mark_topic_as_read_courses(self, course_id, topic_id, **kwargs):
        """
        Mark topic as read
        Mark the initial text of the discussion topic as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_topic_as_read_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_topic_as_read_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_topic_as_read_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_topic_as_read_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_topic_as_read_groups
    def mark_topic_as_read_groups(self, group_id, topic_id, **kwargs):
        """
        Mark topic as read
        Mark the initial text of the discussion topic as read.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_topic_as_read_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_topic_as_read_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_topic_as_read_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_topic_as_read_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_topic_as_unread_courses
    def mark_topic_as_unread_courses(self, course_id, topic_id, **kwargs):
        """
        Mark topic as unread
        Mark the initial text of the discussion topic as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_topic_as_unread_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_topic_as_unread_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `mark_topic_as_unread_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_topic_as_unread_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: mark_topic_as_unread_groups
    def mark_topic_as_unread_groups(self, group_id, topic_id, **kwargs):
        """
        Mark topic as unread
        Mark the initial text of the discussion topic as unread.  No request fields are necessary.  On success, the response will be 204 No Content with an empty body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.mark_topic_as_unread_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_topic_as_unread_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `mark_topic_as_unread_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `mark_topic_as_unread_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/read'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: post_entry_courses
    def post_entry_courses(self, course_id, topic_id, **kwargs):
        """
        Post an entry
        Create a new entry in a discussion topic. Returns a json representation of the created entry (see documentation for 'entries' method) on success.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_entry_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str message: The body of the entry.
        :param str attachment: a multipart/form-data form-field-style attachment. Attachments larger than 1 kilobyte are subject to quota restrictions.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'message', 'attachment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_entry_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `post_entry_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `post_entry_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'attachment' in params:
            form_params.append(('attachment', params['attachment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: post_entry_groups
    def post_entry_groups(self, group_id, topic_id, **kwargs):
        """
        Post an entry
        Create a new entry in a discussion topic. Returns a json representation of the created entry (see documentation for 'entries' method) on success.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_entry_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str message: The body of the entry.
        :param str attachment: a multipart/form-data form-field-style attachment. Attachments larger than 1 kilobyte are subject to quota restrictions.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'message', 'attachment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_entry_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `post_entry_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `post_entry_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'attachment' in params:
            form_params.append(('attachment', params['attachment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: post_reply_courses
    def post_reply_courses(self, course_id, topic_id, entry_id, **kwargs):
        """
        Post a reply
        Add a reply to an entry in a discussion topic. Returns a json representation of the created reply (see documentation for 'replies' method) on success.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_reply_courses_with_http_info(course_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param str message: The body of the entry.
        :param str attachment: a multipart/form-data form-field-style attachment. Attachments larger than 1 kilobyte are subject to quota restrictions.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'entry_id', 'message', 'attachment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_reply_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `post_reply_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `post_reply_courses`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `post_reply_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{entry_id}/replies'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'attachment' in params:
            form_params.append(('attachment', params['attachment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: post_reply_groups
    def post_reply_groups(self, group_id, topic_id, entry_id, **kwargs):
        """
        Post a reply
        Add a reply to an entry in a discussion topic. Returns a json representation of the created reply (see documentation for 'replies' method) on success.  May require (depending on the topic) that the user has posted in the topic. If it is required, and the user has not posted, will respond with a 403 Forbidden status and the body 'require_initial_post'.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_reply_groups_with_http_info(group_id, topic_id, entry_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str entry_id: ID (required)
        :param str message: The body of the entry.
        :param str attachment: a multipart/form-data form-field-style attachment. Attachments larger than 1 kilobyte are subject to quota restrictions.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'entry_id', 'message', 'attachment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_reply_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `post_reply_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `post_reply_groups`")
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params) or (params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `post_reply_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{entry_id}/replies'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'attachment' in params:
            form_params.append(('attachment', params['attachment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reorder_pinned_topics_courses
    def reorder_pinned_topics_courses(self, course_id, order, **kwargs):
        """
        Reorder pinned topics
        Puts the pinned discussion topics in the specified order. All pinned topics should be included.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reorder_pinned_topics_courses_with_http_info(course_id, order, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param list[int] order: The ids of the pinned discussion topics in the desired order. (For example, \"order=104,102,103\".) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'order']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reorder_pinned_topics_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `reorder_pinned_topics_courses`")
        # verify the required parameter 'order' is set
        if ('order' not in params) or (params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `reorder_pinned_topics_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/reorder'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'order' in params:
            form_params.append(('order', params['order']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reorder_pinned_topics_groups
    def reorder_pinned_topics_groups(self, group_id, order, **kwargs):
        """
        Reorder pinned topics
        Puts the pinned discussion topics in the specified order. All pinned topics should be included.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reorder_pinned_topics_groups_with_http_info(group_id, order, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param list[int] order: The ids of the pinned discussion topics in the desired order. (For example, \"order=104,102,103\".) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'order']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reorder_pinned_topics_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `reorder_pinned_topics_groups`")
        # verify the required parameter 'order' is set
        if ('order' not in params) or (params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `reorder_pinned_topics_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/reorder'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'order' in params:
            form_params.append(('order', params['order']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: subscribe_to_topic_courses
    def subscribe_to_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Subscribe to a topic
        Subscribe to a topic to receive notifications about new entries  On success, the response will be 204 No Content with an empty body

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.subscribe_to_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_to_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `subscribe_to_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `subscribe_to_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/subscribed'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: subscribe_to_topic_groups
    def subscribe_to_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Subscribe to a topic
        Subscribe to a topic to receive notifications about new entries  On success, the response will be 204 No Content with an empty body

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.subscribe_to_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_to_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `subscribe_to_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `subscribe_to_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/subscribed'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unsubscribe_from_topic_courses
    def unsubscribe_from_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Unsubscribe from a topic
        Unsubscribe from a topic to stop receiving notifications about new entries  On success, the response will be 204 No Content with an empty body

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unsubscribe_from_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsubscribe_from_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `unsubscribe_from_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `unsubscribe_from_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/subscribed'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unsubscribe_from_topic_groups
    def unsubscribe_from_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Unsubscribe from a topic
        Unsubscribe from a topic to stop receiving notifications about new entries  On success, the response will be 204 No Content with an empty body

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unsubscribe_from_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsubscribe_from_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `unsubscribe_from_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `unsubscribe_from_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/subscribed'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_entry_courses
    def update_entry_courses(self, course_id, topic_id, id, **kwargs):
        """
        Update an entry
        Update an existing discussion entry.  The entry must have been created by the current user, or the current user must have admin rights to the discussion. If the edit is not allowed, a 401 will be returned.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_entry_courses_with_http_info(course_id, topic_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str id: ID (required)
        :param str message: The updated body of the entry.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'id', 'message']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entry_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_entry_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `update_entry_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_entry_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}/entries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_entry_groups
    def update_entry_groups(self, group_id, topic_id, id, **kwargs):
        """
        Update an entry
        Update an existing discussion entry.  The entry must have been created by the current user, or the current user must have admin rights to the discussion. If the edit is not allowed, a 401 will be returned.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_entry_groups_with_http_info(group_id, topic_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str id: ID (required)
        :param str message: The updated body of the entry.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'id', 'message']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_entry_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_entry_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `update_entry_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_entry_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}/entries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'message' in params:
            form_params.append(('message', params['message']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_topic_courses
    def update_topic_courses(self, course_id, topic_id, **kwargs):
        """
        Update a topic
        Update an existing discussion topic for the course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_topic_courses_with_http_info(course_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str topic_id: ID (required)
        :param str title: no description
        :param str message: no description
        :param str discussion_type: The type of discussion. Defaults to side_comment if not value is given. Accepted values are 'side_comment', for discussions that only allow one level of nested comments, and 'threaded' for fully threaded discussions.
        :param bool published: Whether this topic is published (true) or draft state (false). Only teachers and TAs have the ability to create draft state topics.
        :param Object delayed_post_at: If a timestamp is given, the topic will not be published until that time.
        :param Object lock_at: If a timestamp is given, the topic will be scheduled to lock at the provided timestamp. If the timestamp is in the past, the topic will be locked.
        :param bool podcast_enabled: If true, the topic will have an associated podcast feed.
        :param bool podcast_has_student_posts: If true, the podcast will include posts from students as well. Implies podcast_enabled.
        :param bool require_initial_post: If true then a user may not respond to other replies until that user has made an initial reply. Defaults to false.
        :param Object assignment: To create an assignment discussion, pass the assignment parameters as a sub-object. See the {api:AssignmentsApiController#create Create an Assignment API} for the available parameters. The name parameter will be ignored, as it's taken from the discussion title. If you want to make a discussion that was an assignment NOT an assignment, pass set_assignment = false as part of the assignment object
        :param bool is_announcement: If true, this topic is an announcement. It will appear in the announcement's section rather than the discussions section. This requires announcment-posting permissions.
        :param str position_after: By default, discussions are sorted chronologically by creation date, you can pass the id of another topic to have this one show up after the other when they are listed.
        :param int group_category_id: If present, the topic will become a group discussion assigned to the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'topic_id', 'title', 'message', 'discussion_type', 'published', 'delayed_post_at', 'lock_at', 'podcast_enabled', 'podcast_has_student_posts', 'require_initial_post', 'assignment', 'is_announcement', 'position_after', 'group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_topic_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_topic_courses`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `update_topic_courses`")

        resource_path = '/v1/courses/{course_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'discussion_type' in params:
            form_params.append(('discussion_type', params['discussion_type']))
        if 'published' in params:
            form_params.append(('published', params['published']))
        if 'delayed_post_at' in params:
            form_params.append(('delayed_post_at', params['delayed_post_at']))
        if 'lock_at' in params:
            form_params.append(('lock_at', params['lock_at']))
        if 'podcast_enabled' in params:
            form_params.append(('podcast_enabled', params['podcast_enabled']))
        if 'podcast_has_student_posts' in params:
            form_params.append(('podcast_has_student_posts', params['podcast_has_student_posts']))
        if 'require_initial_post' in params:
            form_params.append(('require_initial_post', params['require_initial_post']))
        if 'assignment' in params:
            form_params.append(('assignment', params['assignment']))
        if 'is_announcement' in params:
            form_params.append(('is_announcement', params['is_announcement']))
        if 'position_after' in params:
            form_params.append(('position_after', params['position_after']))
        if 'group_category_id' in params:
            form_params.append(('group_category_id', params['group_category_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_topic_groups
    def update_topic_groups(self, group_id, topic_id, **kwargs):
        """
        Update a topic
        Update an existing discussion topic for the course or group.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_topic_groups_with_http_info(group_id, topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str topic_id: ID (required)
        :param str title: no description
        :param str message: no description
        :param str discussion_type: The type of discussion. Defaults to side_comment if not value is given. Accepted values are 'side_comment', for discussions that only allow one level of nested comments, and 'threaded' for fully threaded discussions.
        :param bool published: Whether this topic is published (true) or draft state (false). Only teachers and TAs have the ability to create draft state topics.
        :param Object delayed_post_at: If a timestamp is given, the topic will not be published until that time.
        :param Object lock_at: If a timestamp is given, the topic will be scheduled to lock at the provided timestamp. If the timestamp is in the past, the topic will be locked.
        :param bool podcast_enabled: If true, the topic will have an associated podcast feed.
        :param bool podcast_has_student_posts: If true, the podcast will include posts from students as well. Implies podcast_enabled.
        :param bool require_initial_post: If true then a user may not respond to other replies until that user has made an initial reply. Defaults to false.
        :param Object assignment: To create an assignment discussion, pass the assignment parameters as a sub-object. See the {api:AssignmentsApiController#create Create an Assignment API} for the available parameters. The name parameter will be ignored, as it's taken from the discussion title. If you want to make a discussion that was an assignment NOT an assignment, pass set_assignment = false as part of the assignment object
        :param bool is_announcement: If true, this topic is an announcement. It will appear in the announcement's section rather than the discussions section. This requires announcment-posting permissions.
        :param str position_after: By default, discussions are sorted chronologically by creation date, you can pass the id of another topic to have this one show up after the other when they are listed.
        :param int group_category_id: If present, the topic will become a group discussion assigned to the group.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'topic_id', 'title', 'message', 'discussion_type', 'published', 'delayed_post_at', 'lock_at', 'podcast_enabled', 'podcast_has_student_posts', 'require_initial_post', 'assignment', 'is_announcement', 'position_after', 'group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_topic_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_topic_groups`")
        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `update_topic_groups`")

        resource_path = '/v1/groups/{group_id}/discussion_topics/{topic_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'topic_id' in params:
            path_params['topic_id'] = params['topic_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'message' in params:
            form_params.append(('message', params['message']))
        if 'discussion_type' in params:
            form_params.append(('discussion_type', params['discussion_type']))
        if 'published' in params:
            form_params.append(('published', params['published']))
        if 'delayed_post_at' in params:
            form_params.append(('delayed_post_at', params['delayed_post_at']))
        if 'lock_at' in params:
            form_params.append(('lock_at', params['lock_at']))
        if 'podcast_enabled' in params:
            form_params.append(('podcast_enabled', params['podcast_enabled']))
        if 'podcast_has_student_posts' in params:
            form_params.append(('podcast_has_student_posts', params['podcast_has_student_posts']))
        if 'require_initial_post' in params:
            form_params.append(('require_initial_post', params['require_initial_post']))
        if 'assignment' in params:
            form_params.append(('assignment', params['assignment']))
        if 'is_announcement' in params:
            form_params.append(('is_announcement', params['is_announcement']))
        if 'position_after' in params:
            form_params.append(('position_after', params['position_after']))
        if 'group_category_id' in params:
            form_params.append(('group_category_id', params['group_category_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
