# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ContentMigration(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, migration_type=None, migration_type_title=None, migration_issues_url=None, attachment=None, progress_url=None, user_id=None, workflow_state=None, started_at=None, finished_at=None, pre_attachment=None):
        """
        ContentMigration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'migration_type': 'str',
            'migration_type_title': 'str',
            'migration_issues_url': 'str',
            'attachment': 'str',
            'progress_url': 'str',
            'user_id': 'int',
            'workflow_state': 'str',
            'started_at': 'Datetime',
            'finished_at': 'Datetime',
            'pre_attachment': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'migration_type': 'migration_type',
            'migration_type_title': 'migration_type_title',
            'migration_issues_url': 'migration_issues_url',
            'attachment': 'attachment',
            'progress_url': 'progress_url',
            'user_id': 'user_id',
            'workflow_state': 'workflow_state',
            'started_at': 'started_at',
            'finished_at': 'finished_at',
            'pre_attachment': 'pre_attachment'
        }

        self._id = id
        self._migration_type = migration_type
        self._migration_type_title = migration_type_title
        self._migration_issues_url = migration_issues_url
        self._attachment = attachment
        self._progress_url = progress_url
        self._user_id = user_id
        self._workflow_state = workflow_state
        self._started_at = started_at
        self._finished_at = finished_at
        self._pre_attachment = pre_attachment

    @property
    def id(self):
        """
        Gets the id of this ContentMigration.
        the unique identifier for the migration

        :return: The id of this ContentMigration.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContentMigration.
        the unique identifier for the migration

        :param id: The id of this ContentMigration.
        :type: int
        """

        self._id = id

    @property
    def migration_type(self):
        """
        Gets the migration_type of this ContentMigration.
        the type of content migration

        :return: The migration_type of this ContentMigration.
        :rtype: str
        """
        return self._migration_type

    @migration_type.setter
    def migration_type(self, migration_type):
        """
        Sets the migration_type of this ContentMigration.
        the type of content migration

        :param migration_type: The migration_type of this ContentMigration.
        :type: str
        """

        self._migration_type = migration_type

    @property
    def migration_type_title(self):
        """
        Gets the migration_type_title of this ContentMigration.
        the name of the content migration type

        :return: The migration_type_title of this ContentMigration.
        :rtype: str
        """
        return self._migration_type_title

    @migration_type_title.setter
    def migration_type_title(self, migration_type_title):
        """
        Sets the migration_type_title of this ContentMigration.
        the name of the content migration type

        :param migration_type_title: The migration_type_title of this ContentMigration.
        :type: str
        """

        self._migration_type_title = migration_type_title

    @property
    def migration_issues_url(self):
        """
        Gets the migration_issues_url of this ContentMigration.
        API url to the content migration's issues

        :return: The migration_issues_url of this ContentMigration.
        :rtype: str
        """
        return self._migration_issues_url

    @migration_issues_url.setter
    def migration_issues_url(self, migration_issues_url):
        """
        Sets the migration_issues_url of this ContentMigration.
        API url to the content migration's issues

        :param migration_issues_url: The migration_issues_url of this ContentMigration.
        :type: str
        """

        self._migration_issues_url = migration_issues_url

    @property
    def attachment(self):
        """
        Gets the attachment of this ContentMigration.
        attachment api object for the uploaded file may not be present for all migrations

        :return: The attachment of this ContentMigration.
        :rtype: str
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment):
        """
        Sets the attachment of this ContentMigration.
        attachment api object for the uploaded file may not be present for all migrations

        :param attachment: The attachment of this ContentMigration.
        :type: str
        """

        self._attachment = attachment

    @property
    def progress_url(self):
        """
        Gets the progress_url of this ContentMigration.
        The api endpoint for polling the current progress

        :return: The progress_url of this ContentMigration.
        :rtype: str
        """
        return self._progress_url

    @progress_url.setter
    def progress_url(self, progress_url):
        """
        Sets the progress_url of this ContentMigration.
        The api endpoint for polling the current progress

        :param progress_url: The progress_url of this ContentMigration.
        :type: str
        """

        self._progress_url = progress_url

    @property
    def user_id(self):
        """
        Gets the user_id of this ContentMigration.
        The user who started the migration

        :return: The user_id of this ContentMigration.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ContentMigration.
        The user who started the migration

        :param user_id: The user_id of this ContentMigration.
        :type: int
        """

        self._user_id = user_id

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this ContentMigration.
        Current state of the content migration: pre_processing, pre_processed, running, waiting_for_select, completed, failed

        :return: The workflow_state of this ContentMigration.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this ContentMigration.
        Current state of the content migration: pre_processing, pre_processed, running, waiting_for_select, completed, failed

        :param workflow_state: The workflow_state of this ContentMigration.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def started_at(self):
        """
        Gets the started_at of this ContentMigration.
        timestamp

        :return: The started_at of this ContentMigration.
        :rtype: Datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """
        Sets the started_at of this ContentMigration.
        timestamp

        :param started_at: The started_at of this ContentMigration.
        :type: Datetime
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """
        Gets the finished_at of this ContentMigration.
        timestamp

        :return: The finished_at of this ContentMigration.
        :rtype: Datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """
        Sets the finished_at of this ContentMigration.
        timestamp

        :param finished_at: The finished_at of this ContentMigration.
        :type: Datetime
        """

        self._finished_at = finished_at

    @property
    def pre_attachment(self):
        """
        Gets the pre_attachment of this ContentMigration.
        file uploading data, see {file:file_uploads.html File Upload Documentation} for file upload workflow This works a little differently in that all the file data is in the pre_attachment hash if there is no upload_url then there was an attachment pre-processing error, the error message will be in the message key This data will only be here after a create or update call

        :return: The pre_attachment of this ContentMigration.
        :rtype: str
        """
        return self._pre_attachment

    @pre_attachment.setter
    def pre_attachment(self, pre_attachment):
        """
        Sets the pre_attachment of this ContentMigration.
        file uploading data, see {file:file_uploads.html File Upload Documentation} for file upload workflow This works a little differently in that all the file data is in the pre_attachment hash if there is no upload_url then there was an attachment pre-processing error, the error message will be in the message key This data will only be here after a create or update call

        :param pre_attachment: The pre_attachment of this ContentMigration.
        :type: str
        """

        self._pre_attachment = pre_attachment

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
