# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ReportParameters(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, enrollment_term_id=None, include_deleted=None, course_id=None, order=None, users=None, accounts=None, terms=None, courses=None, sections=None, enrollments=None, groups=None, xlist=None, sis_terms_csv=None, sis_accounts_csv=None, include_enrollment_state=None, enrollment_state=None, start_at=None, end_at=None):
        """
        ReportParameters - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enrollment_term_id': 'int',
            'include_deleted': 'bool',
            'course_id': 'int',
            'order': 'str',
            'users': 'bool',
            'accounts': 'bool',
            'terms': 'bool',
            'courses': 'bool',
            'sections': 'bool',
            'enrollments': 'bool',
            'groups': 'bool',
            'xlist': 'bool',
            'sis_terms_csv': 'int',
            'sis_accounts_csv': 'int',
            'include_enrollment_state': 'bool',
            'enrollment_state': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime'
        }

        self.attribute_map = {
            'enrollment_term_id': 'enrollment_term_id',
            'include_deleted': 'include_deleted',
            'course_id': 'course_id',
            'order': 'order',
            'users': 'users',
            'accounts': 'accounts',
            'terms': 'terms',
            'courses': 'courses',
            'sections': 'sections',
            'enrollments': 'enrollments',
            'groups': 'groups',
            'xlist': 'xlist',
            'sis_terms_csv': 'sis_terms_csv',
            'sis_accounts_csv': 'sis_accounts_csv',
            'include_enrollment_state': 'include_enrollment_state',
            'enrollment_state': 'enrollment_state[]',
            'start_at': 'start_at',
            'end_at': 'end_at'
        }

        self._enrollment_term_id = enrollment_term_id
        self._include_deleted = include_deleted
        self._course_id = course_id
        self._order = order
        self._users = users
        self._accounts = accounts
        self._terms = terms
        self._courses = courses
        self._sections = sections
        self._enrollments = enrollments
        self._groups = groups
        self._xlist = xlist
        self._sis_terms_csv = sis_terms_csv
        self._sis_accounts_csv = sis_accounts_csv
        self._include_enrollment_state = include_enrollment_state
        self._enrollment_state = enrollment_state
        self._start_at = start_at
        self._end_at = end_at

    @property
    def enrollment_term_id(self):
        """
        Gets the enrollment_term_id of this ReportParameters.
        The canvas id of the term to get grades from

        :return: The enrollment_term_id of this ReportParameters.
        :rtype: int
        """
        return self._enrollment_term_id

    @enrollment_term_id.setter
    def enrollment_term_id(self, enrollment_term_id):
        """
        Sets the enrollment_term_id of this ReportParameters.
        The canvas id of the term to get grades from

        :param enrollment_term_id: The enrollment_term_id of this ReportParameters.
        :type: int
        """

        self._enrollment_term_id = enrollment_term_id

    @property
    def include_deleted(self):
        """
        Gets the include_deleted of this ReportParameters.
        Include deleted objects

        :return: The include_deleted of this ReportParameters.
        :rtype: bool
        """
        return self._include_deleted

    @include_deleted.setter
    def include_deleted(self, include_deleted):
        """
        Sets the include_deleted of this ReportParameters.
        Include deleted objects

        :param include_deleted: The include_deleted of this ReportParameters.
        :type: bool
        """

        self._include_deleted = include_deleted

    @property
    def course_id(self):
        """
        Gets the course_id of this ReportParameters.
        The course to report on

        :return: The course_id of this ReportParameters.
        :rtype: int
        """
        return self._course_id

    @course_id.setter
    def course_id(self, course_id):
        """
        Sets the course_id of this ReportParameters.
        The course to report on

        :param course_id: The course_id of this ReportParameters.
        :type: int
        """

        self._course_id = course_id

    @property
    def order(self):
        """
        Gets the order of this ReportParameters.
        The sort order for the csv, Options: 'users', 'courses', 'outcomes'.

        :return: The order of this ReportParameters.
        :rtype: str
        """
        return self._order

    @order.setter
    def order(self, order):
        """
        Sets the order of this ReportParameters.
        The sort order for the csv, Options: 'users', 'courses', 'outcomes'.

        :param order: The order of this ReportParameters.
        :type: str
        """

        self._order = order

    @property
    def users(self):
        """
        Gets the users of this ReportParameters.
        Get the data for users

        :return: The users of this ReportParameters.
        :rtype: bool
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this ReportParameters.
        Get the data for users

        :param users: The users of this ReportParameters.
        :type: bool
        """

        self._users = users

    @property
    def accounts(self):
        """
        Gets the accounts of this ReportParameters.
        Get the data for accounts

        :return: The accounts of this ReportParameters.
        :rtype: bool
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """
        Sets the accounts of this ReportParameters.
        Get the data for accounts

        :param accounts: The accounts of this ReportParameters.
        :type: bool
        """

        self._accounts = accounts

    @property
    def terms(self):
        """
        Gets the terms of this ReportParameters.
        Get the data for terms

        :return: The terms of this ReportParameters.
        :rtype: bool
        """
        return self._terms

    @terms.setter
    def terms(self, terms):
        """
        Sets the terms of this ReportParameters.
        Get the data for terms

        :param terms: The terms of this ReportParameters.
        :type: bool
        """

        self._terms = terms

    @property
    def courses(self):
        """
        Gets the courses of this ReportParameters.
        Get the data for courses

        :return: The courses of this ReportParameters.
        :rtype: bool
        """
        return self._courses

    @courses.setter
    def courses(self, courses):
        """
        Sets the courses of this ReportParameters.
        Get the data for courses

        :param courses: The courses of this ReportParameters.
        :type: bool
        """

        self._courses = courses

    @property
    def sections(self):
        """
        Gets the sections of this ReportParameters.
        Get the data for sections

        :return: The sections of this ReportParameters.
        :rtype: bool
        """
        return self._sections

    @sections.setter
    def sections(self, sections):
        """
        Sets the sections of this ReportParameters.
        Get the data for sections

        :param sections: The sections of this ReportParameters.
        :type: bool
        """

        self._sections = sections

    @property
    def enrollments(self):
        """
        Gets the enrollments of this ReportParameters.
        Get the data for enrollments

        :return: The enrollments of this ReportParameters.
        :rtype: bool
        """
        return self._enrollments

    @enrollments.setter
    def enrollments(self, enrollments):
        """
        Sets the enrollments of this ReportParameters.
        Get the data for enrollments

        :param enrollments: The enrollments of this ReportParameters.
        :type: bool
        """

        self._enrollments = enrollments

    @property
    def groups(self):
        """
        Gets the groups of this ReportParameters.
        Get the data for groups

        :return: The groups of this ReportParameters.
        :rtype: bool
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this ReportParameters.
        Get the data for groups

        :param groups: The groups of this ReportParameters.
        :type: bool
        """

        self._groups = groups

    @property
    def xlist(self):
        """
        Gets the xlist of this ReportParameters.
        Get the data for cross-listed courses

        :return: The xlist of this ReportParameters.
        :rtype: bool
        """
        return self._xlist

    @xlist.setter
    def xlist(self, xlist):
        """
        Sets the xlist of this ReportParameters.
        Get the data for cross-listed courses

        :param xlist: The xlist of this ReportParameters.
        :type: bool
        """

        self._xlist = xlist

    @property
    def sis_terms_csv(self):
        """
        Gets the sis_terms_csv of this ReportParameters.


        :return: The sis_terms_csv of this ReportParameters.
        :rtype: int
        """
        return self._sis_terms_csv

    @sis_terms_csv.setter
    def sis_terms_csv(self, sis_terms_csv):
        """
        Sets the sis_terms_csv of this ReportParameters.


        :param sis_terms_csv: The sis_terms_csv of this ReportParameters.
        :type: int
        """

        self._sis_terms_csv = sis_terms_csv

    @property
    def sis_accounts_csv(self):
        """
        Gets the sis_accounts_csv of this ReportParameters.


        :return: The sis_accounts_csv of this ReportParameters.
        :rtype: int
        """
        return self._sis_accounts_csv

    @sis_accounts_csv.setter
    def sis_accounts_csv(self, sis_accounts_csv):
        """
        Sets the sis_accounts_csv of this ReportParameters.


        :param sis_accounts_csv: The sis_accounts_csv of this ReportParameters.
        :type: int
        """

        self._sis_accounts_csv = sis_accounts_csv

    @property
    def include_enrollment_state(self):
        """
        Gets the include_enrollment_state of this ReportParameters.
        Include enrollment state. Defaults to false

        :return: The include_enrollment_state of this ReportParameters.
        :rtype: bool
        """
        return self._include_enrollment_state

    @include_enrollment_state.setter
    def include_enrollment_state(self, include_enrollment_state):
        """
        Sets the include_enrollment_state of this ReportParameters.
        Include enrollment state. Defaults to false

        :param include_enrollment_state: The include_enrollment_state of this ReportParameters.
        :type: bool
        """

        self._include_enrollment_state = include_enrollment_state

    @property
    def enrollment_state(self):
        """
        Gets the enrollment_state of this ReportParameters.
        Include enrollment state. Defaults to 'all' Options: ['active'| 'invited'| 'creation_pending'| 'deleted'| 'rejected'| 'completed'| 'inactive'| 'all']

        :return: The enrollment_state of this ReportParameters.
        :rtype: str
        """
        return self._enrollment_state

    @enrollment_state.setter
    def enrollment_state(self, enrollment_state):
        """
        Sets the enrollment_state of this ReportParameters.
        Include enrollment state. Defaults to 'all' Options: ['active'| 'invited'| 'creation_pending'| 'deleted'| 'rejected'| 'completed'| 'inactive'| 'all']

        :param enrollment_state: The enrollment_state of this ReportParameters.
        :type: str
        """

        self._enrollment_state = enrollment_state

    @property
    def start_at(self):
        """
        Gets the start_at of this ReportParameters.
        The beginning date for submissions. Max time range is 2 weeks.

        :return: The start_at of this ReportParameters.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this ReportParameters.
        The beginning date for submissions. Max time range is 2 weeks.

        :param start_at: The start_at of this ReportParameters.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this ReportParameters.
        The end date for submissions. Max time range is 2 weeks.

        :return: The end_at of this ReportParameters.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this ReportParameters.
        The end date for submissions. Max time range is 2 weeks.

        :param end_at: The end_at of this ReportParameters.
        :type: Datetime
        """

        self._end_at = end_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
