/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8091216485095130416L;
    private double quantile = 0.0;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double d) {
        this.setQuantile(d);
    }

    public double evaluate(double[] dArray, double d) {
        this.test(dArray, 0, 0);
        return this.evaluate(dArray, 0, dArray.length, d);
    }

    public double evaluate(double[] dArray, int n, int n2) {
        return this.evaluate(dArray, n, n2, this.quantile);
    }

    public double evaluate(double[] dArray, int n, int n2, double d) {
        this.test(dArray, n, n2);
        if (d > 100.0 || d <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + d);
        }
        if (n2 == 0) {
            return Double.NaN;
        }
        if (n2 == 1) {
            return dArray[n];
        }
        double d2 = n2;
        double d3 = d * (d2 + 1.0) / 100.0;
        double d4 = Math.floor(d3);
        int n3 = (int)d4;
        double d5 = d3 - d4;
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, n, dArray2, 0, n2);
        Arrays.sort(dArray2);
        if (d3 < 1.0) {
            return dArray2[0];
        }
        if (d3 >= d2) {
            return dArray2[n2 - 1];
        }
        double d6 = dArray2[n3 - 1];
        double d7 = dArray2[n3];
        return d6 + d5 * (d7 - d6);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double d) {
        if (d <= 0.0 || d > 100.0) {
            throw new IllegalArgumentException("Illegal quantile value: " + d);
        }
        this.quantile = d;
    }
}

