/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import java.util.Vector;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.PeakSlidingWindow;
import net.alomax.timedom.RecursionFilter;
import net.alomax.timedom.Smoothing;
import net.alomax.timedom.TestPicker3;
import net.alomax.timedom.TestPicker4;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcesses;
import net.alomax.timedom.TimeDomainText;

public abstract class TimeDomainProcess {
    protected TimeDomainMemory memory = null;
    protected boolean useMemory = false;

    public abstract float[] apply(double var1, float[] var3) throws TimeDomainException;

    public abstract void updateFields(TimeSeries var1);

    public abstract void checkSettings() throws TimeDomainException;

    public abstract boolean amplititudeModified();

    public boolean supportsMemory() {
        return false;
    }

    public TimeDomainMemory getMemory() {
        return this.memory;
    }

    public void setMemory(TimeDomainMemory timeDomainMemory) {
        this.memory = timeDomainMemory;
    }

    public void setUseMemory(boolean bl) throws TimeDomainException {
        if (bl && !this.supportsMemory()) {
            throw new TimeDomainException(TimeDomainText.does_not_support_memory + ": " + this);
        }
        this.useMemory = bl;
    }

    public static TimeDomainProcess copy(TimeDomainProcess timeDomainProcess) throws TimeDomainException {
        if (timeDomainProcess instanceof RecursionFilter) {
            return new RecursionFilter((RecursionFilter)timeDomainProcess);
        }
        if (timeDomainProcess instanceof TimeDomainProcesses) {
            return new TimeDomainProcesses((TimeDomainProcesses)timeDomainProcess);
        }
        if (timeDomainProcess instanceof Smoothing) {
            return new Smoothing((Smoothing)timeDomainProcess);
        }
        if (timeDomainProcess instanceof PeakSlidingWindow) {
            return new PeakSlidingWindow((PeakSlidingWindow)timeDomainProcess);
        }
        if (timeDomainProcess instanceof TestPicker3) {
            return new TestPicker3((TestPicker3)timeDomainProcess);
        }
        if (timeDomainProcess instanceof TestPicker4) {
            return new TestPicker4((TestPicker4)timeDomainProcess);
        }
        throw new TimeDomainException(TimeDomainText.does_not_support_copy + ": " + timeDomainProcess);
    }

    public Vector getPickData() {
        return null;
    }

    public void clearTriggerPickData() {
    }

    public String getPickPrefix() {
        return "X";
    }
}

