/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class DurationAmplitude
extends TimeDomainProcess {
    public static final double MWPD_CONST = 1.886E19;
    public double mwpdConst = 1.886E19;
    private static final double MWPD_CONST_MIN = -1.7976931348623157E308;
    private static final double MWPD_CONST_MAX = Double.MAX_VALUE;
    public static final String RESULT_MOMENT = "MOMENT";
    public static final String RESULT_MAGNITUDE = "MAGNITUDE";
    public static final String RESULT_ERROR = "ERROR";
    public static final int MOMENT = 0;
    public static final int MAGNITUDE = 1;
    public int resultType = 0;
    public String errorMessage;
    protected static double log10 = Math.log(10.0);
    protected static double multiplier = 0.6666666666666666;
    protected static double constant = 9.1;

    public DurationAmplitude(String string, double d) {
        this.mwpdConst = d;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setMwpdConst(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_mwpdConst_value);
        }
        this.mwpdConst = d;
    }

    public void setMwpdConst(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_mwpdConst_value);
        }
        this.setMwpdConst(d);
    }

    public void setResultsType(String string) throws TimeDomainException {
        if (RESULT_MOMENT.startsWith(string.toUpperCase())) {
            this.resultType = 0;
        } else if (RESULT_MAGNITUDE.startsWith(string.toUpperCase())) {
            this.resultType = 1;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_result_value + ": " + string);
        }
    }

    public String getResultsTypeString() {
        if (this.resultType == 0) {
            return RESULT_MOMENT;
        }
        if (this.resultType == 1) {
            return RESULT_MAGNITUDE;
        }
        return RESULT_ERROR;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.mwpdConst < -1.7976931348623157E308 || this.mwpdConst > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_mwpdConst_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        fArray[0] = 0.0f;
        double d2 = d;
        for (int i = 1; i < fArray.length; ++i) {
            double d3 = this.mwpdConst * (double)fArray[i];
            if (this.resultType == 0) {
                fArray[i] = (float)d3;
            } else {
                double d4 = 0.0;
                if (d3 > (double)1.4E-45f) {
                    d4 = multiplier * (Math.log(d3) / log10 - constant);
                }
                fArray[i] = (float)d4;
            }
            d2 += d;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = this.resultType == 0 ? "Nm" : (this.resultType == 1 ? "Mwpd" : RESULT_ERROR);
    }

    public boolean amplititudeModified() {
        return true;
    }
}

