/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import java.util.Vector;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public abstract class BasicPicker
extends TimeDomainProcess {
    public static final String DIR_FORWARD = "FORWARD";
    public static final String DIR_BACKWARD = "BACKWARD";
    public int direction = 1;
    public static final String RESULT_PICKS = "PICKS";
    public static final String RESULT_CHAR_FUNC = "CHAR_FUNC";
    public static final String RESULT_TRIGGER = "TRIGGERS";
    public static final String RESULT_ERROR = "ERROR";
    public static final int PICKS = 0;
    public static final int CHAR_FUNC = 1;
    public static final int TRIGGER = 2;
    public int resultType = 0;
    public String errorMessage = " ";
    protected Vector triggerPickData = new Vector();

    public BasicPicker(String string, int n) {
        this.direction = n;
        TimeDomainText.setLocale(string);
    }

    public BasicPicker(int n) {
        this.direction = n;
    }

    public void setDirection(int n) throws TimeDomainException {
        if (n != 1 && n != -1) {
            throw new TimeDomainException(TimeDomainText.invalid_direction_value + ": " + n);
        }
        this.direction = n;
    }

    public void setDirection(String string) throws TimeDomainException {
        if (DIR_FORWARD.startsWith(string.toUpperCase())) {
            this.direction = 1;
        } else if (DIR_BACKWARD.startsWith(string.toUpperCase())) {
            this.direction = -1;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_direction_value + ": " + string);
        }
    }

    public String getDirectionString() {
        if (this.direction == 1) {
            return DIR_FORWARD;
        }
        return DIR_BACKWARD;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setResultsType(String string) throws TimeDomainException {
        if (RESULT_PICKS.startsWith(string.toUpperCase())) {
            this.resultType = 0;
        } else if (RESULT_CHAR_FUNC.startsWith(string.toUpperCase())) {
            this.resultType = 1;
        } else if (RESULT_TRIGGER.startsWith(string.toUpperCase())) {
            this.resultType = 2;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_result_value + ": " + string);
        }
    }

    public String getResultsTypeString() {
        if (this.resultType == 0) {
            return RESULT_PICKS;
        }
        if (this.resultType == 1) {
            return RESULT_CHAR_FUNC;
        }
        if (this.resultType == 2) {
            return RESULT_TRIGGER;
        }
        return RESULT_ERROR;
    }

    public int getResultsType() {
        return this.resultType;
    }

    public Vector getPickData() {
        return this.triggerPickData;
    }

    public void clearTriggerPickData() {
        this.triggerPickData = new Vector();
    }

    public String getPickPrefix() {
        return "T";
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.direction != 1 && this.direction != -1) {
            string = string + ": " + TimeDomainText.invalid_direction_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
        this.clearTriggerPickData();
    }

    public abstract float[] apply(double var1, float[] var3);

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = "counts";
    }

    public boolean amplititudeModified() {
        return this.resultType != 0;
    }
}

