/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.alomax.awt.AJLColor;
import net.alomax.io.DirectoryLister;
import net.alomax.swing.InteractionListener;
import net.alomax.swing.InteractionTextAreaActionEvent;
import net.alomax.util.StringExt;

public class InteractionTextArea
extends JScrollPane
implements CaretListener,
KeyListener,
ActionListener {
    public static final String NEWLINE = System.getProperty("line.separator");
    protected int rows;
    protected int columns;
    protected int verticalScrollBarPolicy;
    protected JTextArea textArea;
    protected Color foreground;
    protected Color background;
    protected InteractionListener interactionListener = null;
    protected Vector commandVector = new Vector();
    protected int commandVectorIndex = this.commandVector.size();
    protected Font fixedWidthFont = null;
    protected int keyCount = 0;

    public InteractionTextArea(String string, int n, int n2, int n3, InteractionListener interactionListener, Color color, Color color2) {
        super(n3, 30);
        this.rows = n;
        this.columns = n2;
        this.verticalScrollBarPolicy = n3;
        this.foreground = color;
        this.background = color2;
        this.textArea = new JTextArea(string, n, n2);
        this.setViewportView(this.textArea);
        this.textArea.addCaretListener(this);
        this.textArea.addKeyListener(this);
        this.textArea.setForeground(color);
        this.textArea.setBackground(color2);
        this.textArea.setLineWrap(true);
        this.textArea.setCaretColor(AJLColor.invert(color2));
        this.interactionListener = interactionListener;
    }

    public void setFont() {
        Font font;
        try {
            font = this.textArea.getGraphics().getFont();
        }
        catch (Exception exception) {
            return;
        }
        this.fixedWidthFont = new Font("Monospaced", font.getStyle(), font.getSize());
        this.textArea.setFont(this.fixedWidthFont);
    }

    public void writeMessage(String string) {
        InteractionTextAreaActionEvent interactionTextAreaActionEvent = new InteractionTextAreaActionEvent(this, string);
        this.getToolkit().getSystemEventQueue().postEvent(interactionTextAreaActionEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent instanceof InteractionTextAreaActionEvent) {
            String string;
            String string2 = ((InteractionTextAreaActionEvent)actionEvent).message;
            if (this.fixedWidthFont == null) {
                this.setFont();
            }
            try {
                if (string2.equals("_READY")) {
                    this.textArea.append("\n> ");
                } else if (string2.equals("_PROMPT")) {
                    this.textArea.append("> ");
                } else if (string2.endsWith("...")) {
                    this.textArea.append(string2);
                } else if (string2.endsWith("_NO_PROMPT")) {
                    this.textArea.append(string2.substring(0, string2.lastIndexOf("_NO_PROMPT")) + "\n");
                } else if (string2.endsWith("_NO_RETURN")) {
                    this.textArea.append(string2.substring(0, string2.lastIndexOf("_NO_RETURN")));
                } else if (string2.endsWith("_OVERWRITE")) {
                    String string3 = this.textArea.getText();
                    this.textArea.setText(string3.substring(0, string3.lastIndexOf(">") + 1));
                    this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
                    this.textArea.append(" ");
                    this.textArea.append(string2.substring(0, string2.lastIndexOf("_OVERWRITE")));
                } else {
                    this.textArea.append(string2 + "\n> ");
                }
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
            }
            catch (Throwable throwable) {
                string = "ERROR: Writing to interaction panel: " + throwable;
                System.out.println(string);
            }
            try {
                int n = 50;
                int n2 = 120;
                if (this.textArea.getCaretPosition() > n2 * (3 * n / 2)) {
                    String string4 = this.textArea.getText();
                    string4 = string4.substring(string4.length() - n2 * n, string4.length());
                    this.textArea = null;
                    Runtime.getRuntime().gc();
                    this.textArea = new JTextArea(string4, this.rows, this.columns);
                    this.textArea.setForeground(this.foreground);
                    this.textArea.setBackground(this.background);
                    this.textArea.setLineWrap(true);
                    this.setViewportView(this.textArea);
                    this.setFont();
                    this.validate();
                    this.textArea.addKeyListener(this);
                    this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
                }
            }
            catch (Throwable throwable) {
                string = "ERROR: Compacting interaction panel: " + throwable;
                System.out.println(string);
            }
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.textArea.getCaretPosition();
        try {
            if (n > 2 && this.textArea.getText(n - 2, 2).equals("\n>") && this.textArea.getDocument().getLength() > n) {
                this.textArea.replaceRange(" ", n, n + 1);
                this.textArea.setCaretPosition(n + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            int n2 = this.textArea.getCaretPosition();
            try {
                if (n2 > 3 && this.textArea.getText(n2 - 3, 2).equals("\n>")) {
                    this.textArea.append(" ");
                    this.textArea.setCaretPosition(n2 + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            String string = this.textArea.getText();
            string = string.substring(string.lastIndexOf(">") + 1);
            string = StringExt.replace(string, "\n", "");
            this.commandVector.addElement(string.trim());
            this.commandVectorIndex = this.commandVector.size();
            int n2 = string.indexOf("!");
            if (n2 >= 0) {
                if (string.length() > n2 + 1) {
                    this.runSystemCommand(string.substring(n2 + 1));
                } else {
                    this.writeMessage("_PROMPT");
                }
            } else if (this.interactionListener != null && string.length() > 0) {
                this.interactionListener.commandEntered(string);
            }
        } else if (n == 38) {
            if (this.commandVectorIndex > 0) {
                --this.commandVectorIndex;
                this.writeMessage((String)this.commandVector.elementAt(this.commandVectorIndex) + "_OVERWRITE");
            } else {
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
        } else if (n == 40) {
            if (this.commandVectorIndex < this.commandVector.size() - 1) {
                ++this.commandVectorIndex;
                this.writeMessage((String)this.commandVector.elementAt(this.commandVectorIndex) + "_OVERWRITE");
            } else {
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
        } else if (n == 9) {
            this.expandTab();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void expandTab() {
        try {
            String string = this.textArea.getText();
            String string2 = string.substring(string.lastIndexOf(">") + 1);
            int n = string2.lastIndexOf(" ");
            if (n < 0) {
                this.writeMessage("_OVERWRITE");
                return;
            }
            String string3 = string2.substring(n).trim();
            if (string3.length() < 1) {
                return;
            }
            System.out.println("prefix: <" + string3 + ">");
            String string4 = null;
            String string5 = ".";
            n = string3.lastIndexOf(File.separatorChar);
            if (n >= 0) {
                string5 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
            }
            System.out.println("prefix: <" + string3 + ">");
            System.out.println("dir: " + string5 + "  File.separatorChar: " + File.separatorChar);
            String[] stringArray = DirectoryLister.getDirectoryList(string5, null, false);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string3)) continue;
                string4 = string4 == null ? stringArray[i] : "";
            }
            if (string4 == null) {
                string4 = "";
            }
            string2 = string2.substring(0, string2.lastIndexOf(string3) - string3.length() + 1);
            string2 = string2 + string4;
            this.writeMessage(string2.trim() + "_OVERWRITE");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected void runSystemCommand(String string) {
        try {
            int n;
            Object object;
            String string2 = System.getProperty("os.name");
            boolean bl = false;
            if (string2.toUpperCase().indexOf("WINDOWS") >= 0) {
                bl = true;
            }
            Process process = bl ? Runtime.getRuntime().exec("cmd /C " + string + NEWLINE) : Runtime.getRuntime().exec("sh");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getInputStream());
            if (!bl) {
                object = process.getOutputStream();
                ((OutputStream)object).write((string + "&\nexit\n").getBytes());
                ((OutputStream)object).flush();
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = bufferedInputStream.read()) > 0) {
                    stringBuffer.append((char)n);
                }
                stringBuffer.append("_NO_PROMPT");
                this.writeMessage(stringBuffer.toString());
            }
            object = new StringBuffer();
            while ((n = bufferedInputStream2.read()) >= 0) {
                ((StringBuffer)object).append((char)n);
            }
            this.writeMessage(((StringBuffer)object).toString());
            process.waitFor();
            return;
        }
        catch (Exception exception) {
            String string3 = "ERROR: running system command: \"" + string + "\" : " + exception;
            System.out.println(string3);
            this.writeMessage(string3);
            exception.printStackTrace();
            return;
        }
    }
}

