/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.alomax.animator.Animator;
import net.alomax.animator.AnimatorClient;

public class BusyIndicator
extends JLabel
implements AnimatorClient {
    protected static int numRunning = 0;
    protected Animator animator = null;
    protected ImageIcon[] busyImageIcon = new ImageIcon[7];
    protected ImageIcon notBusyImageIcon = null;
    protected ImageIcon errorImageIcon = null;
    protected ImageIcon warningImageIcon = null;
    protected ImageIcon informationImageIcon = null;
    protected ImageIcon reloadImageIcon = null;
    protected int imageIndex = 0;
    protected boolean running = false;
    protected boolean iconIsBusyIndicator = true;
    protected JTextField messageBox;

    public BusyIndicator(JTextField jTextField) {
        this.messageBox = jTextField;
        try {
            Image image;
            Image image2 = this.getToolkit().getImage(this.getClass().getResource("not_busy.gif"));
            this.notBusyImageIcon = new ImageIcon(image2);
            for (int i = 0; i < this.busyImageIcon.length; ++i) {
                image = this.getToolkit().getImage(this.getClass().getResource("busy" + (i + 1) + ".gif"));
                this.busyImageIcon[i] = new ImageIcon(image);
            }
            Image image3 = this.getToolkit().getImage(this.getClass().getResource("error.gif"));
            this.errorImageIcon = new ImageIcon(image3);
            image = this.getToolkit().getImage(this.getClass().getResource("warning.gif"));
            this.warningImageIcon = new ImageIcon(image);
            Image image4 = this.getToolkit().getImage(this.getClass().getResource("information.gif"));
            this.informationImageIcon = new ImageIcon(image4);
            Image image5 = this.getToolkit().getImage(this.getClass().getResource("reload.gif"));
            this.reloadImageIcon = new ImageIcon(image5);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (this.notBusyImageIcon != null) {
            this.setIcon(this.notBusyImageIcon);
        }
        this.animator = new Animator(this, 0, 500, 500);
        if (this.animator != null) {
            this.animator.start();
        }
        this.running = false;
    }

    public void finalize() throws Throwable {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.animator = null;
    }

    public synchronized void start(String string) {
        if (this.messageBox != null) {
            this.messageBox.setText(" " + string);
            Graphics graphics = this.messageBox.getGraphics();
            if (graphics != null) {
                this.messageBox.paint(graphics);
                graphics.dispose();
            }
        }
        if (numRunning == 0) {
            this.paintCurrentFrame();
        }
        this.running = true;
        this.iconIsBusyIndicator = true;
        ++numRunning;
    }

    public synchronized void stop() {
        if (numRunning > 0) {
            --numRunning;
        }
        if (numRunning < 1) {
            this.running = false;
            if (this.iconIsBusyIndicator) {
                if (this.notBusyImageIcon != null) {
                    this.setIcon(this.notBusyImageIcon);
                }
                if (this.messageBox != null) {
                    this.messageBox.setText("");
                    Graphics graphics = this.messageBox.getGraphics();
                    if (graphics != null) {
                        this.messageBox.paint(graphics);
                        graphics.dispose();
                    }
                }
                this.iconIsBusyIndicator = false;
            }
        }
    }

    public boolean paintNextFrame(int n, long l) {
        int n2 = this.imageIndex = ++this.imageIndex < this.busyImageIcon.length ? this.imageIndex : 0;
        if (!this.running) {
            return false;
        }
        this.paintCurrentFrame();
        return false;
    }

    public void paintCurrentFrame() {
        if (!this.iconIsBusyIndicator) {
            return;
        }
        if (this.busyImageIcon[this.imageIndex] != null) {
            this.setIcon(this.busyImageIcon[this.imageIndex]);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
    }

    public synchronized void showNothing() {
        if (this.notBusyImageIcon != null) {
            this.setIcon(this.notBusyImageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }

    public synchronized void showInformation() {
        if (this.informationImageIcon != null) {
            this.setIcon(this.informationImageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }

    public synchronized void showWarning() {
        if (this.warningImageIcon != null) {
            this.setIcon(this.warningImageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }

    public synchronized void showError() {
        if (this.errorImageIcon != null) {
            this.setIcon(this.errorImageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }

    public synchronized void showReload() {
        if (this.reloadImageIcon != null) {
            this.setIcon(this.reloadImageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }

    public synchronized void showCustom(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.setIcon(imageIcon);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
        this.iconIsBusyIndicator = false;
    }
}

