/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.freq.FilterException;
import net.alomax.freq.FreqText;
import net.alomax.freq.PoleZeroResponse;
import net.alomax.freq.Response;
import net.alomax.freq.ResponseException;
import net.alomax.freq.Transfer;
import net.alomax.math.Cmplx;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.util.PhysicalUnits;

public class TransferToolManager
extends JToolManager {
    protected static final String THIS_RESPONSE_SHORT_NAME = "THIS";
    protected static Response[] responses = new Response[5];
    protected static Response NONE_RESPONSE = null;
    private static int count = 0;
    protected SeisGram2KFrame seisFrame = null;
    protected Transfer transfer = null;
    protected AJLJButton buttonApplyTransfer;
    protected JComboBox choiceFrom;
    protected JComboBox choiceTo;
    protected JTextField textFieldFreq0;
    protected JTextField textFieldFreq1;
    protected JTextField textFieldFreq2;
    protected JTextField textFieldFreq3;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public TransferToolManager(SeisGram2KFrame seisGram2KFrame) throws ResponseException {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.transfer = new Transfer(SeisGramText.getLocaleString(), NONE_RESPONSE, NONE_RESPONSE);
        double[] dArray = new double[]{0.0, 0.0, 1.0E30, 1.0E30};
        this.transfer.setFreqLimits(dArray);
        this.commandNames = new String[]{"transfer"};
        this.commandNamesShort = new String[]{"trans"};
    }

    public void updateLabel() {
        this.label = SeisGramText.TRANSFER;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        String[] stringArray = new String[responses.length + 1];
        stringArray[0] = THIS_RESPONSE_SHORT_NAME;
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = responses[i - 1].getShortName();
        }
        String[] stringArray2 = new String[responses.length + 1];
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            stringArray2[i] = responses[i].getShortName();
        }
        stringArray2[stringArray2.length - 1] = THIS_RESPONSE_SHORT_NAME;
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyTransfer = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyTransfer);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.FROM + ":", 4));
        this.choiceFrom = SwingExt.newChoice(this, stringArray);
        jToolBar.add(this.choiceFrom);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TO + ":", 4));
        this.choiceTo = SwingExt.newChoice(this, stringArray2);
        jToolBar.add(this.choiceTo);
        jToolBar.addSeparator();
        double[] dArray = this.transfer.getFreqLimits();
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("f0:", 4));
        this.textFieldFreq0 = SwingExt.newJTextField(this, this, String.valueOf(dArray[0]), 4);
        jToolBar.add(this.textFieldFreq0);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("f1:", 4));
        this.textFieldFreq1 = SwingExt.newJTextField(this, this, String.valueOf(dArray[1]), 4);
        jToolBar.add(this.textFieldFreq1);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("f2:", 4));
        this.textFieldFreq2 = SwingExt.newJTextField(this, this, String.valueOf(dArray[2]), 4);
        jToolBar.add(this.textFieldFreq2);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("f3:", 4));
        this.textFieldFreq3 = SwingExt.newJTextField(this, this, String.valueOf(dArray[3]), 4);
        jToolBar.add(this.textFieldFreq3);
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyTransfer)) {
            String[] stringArray;
            boolean bl = false;
            try {
                this.transfer.setToResponse(this.getResponseFromShortName((String)this.choiceTo.getSelectedItem(), null));
                this.transfer.setFromResponse(this.getResponseFromShortName((String)this.choiceFrom.getSelectedItem(), null));
            }
            catch (ResponseException responseException) {
                this.seisFrame.writeMessage("ERROR: " + responseException.toString());
                bl = true;
            }
            try {
                stringArray = new String[]{this.textFieldFreq0.getText(), this.textFieldFreq1.getText(), this.textFieldFreq2.getText(), this.textFieldFreq3.getText()};
                this.transfer.setFreqLimits(stringArray);
            }
            catch (ResponseException responseException) {
                this.seisFrame.writeMessage("ERROR: " + responseException.toString());
                bl = true;
            }
            stringArray = (String[])this.transfer.getFreqLimits();
            this.textFieldFreq0.setText(String.valueOf((double)stringArray[0]));
            this.textFieldFreq1.setText(String.valueOf((double)stringArray[1]));
            this.textFieldFreq2.setText(String.valueOf((double)stringArray[2]));
            this.textFieldFreq3.setText(String.valueOf((double)stringArray[3]));
            if (bl) {
                return;
            }
            try {
                this.transfer.checkSettings();
            }
            catch (ResponseException responseException) {
                this.seisFrame.writeMessage("ERROR: " + responseException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (Exception exception) {
                this.seisFrame.writeMessage("ERROR: " + exception.toString());
            }
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    protected Response getResponseFromShortName(String string, StringTokenizer stringTokenizer) throws ResponseException {
        if (string.equalsIgnoreCase(THIS_RESPONSE_SHORT_NAME)) {
            return this.seisFrame.getActiveGather().getSeismogram(this.seisFrame.getActiveGather().getActiveSeismogram()).getResponse(this.seisFrame.getDocumentBase(), null);
        }
        for (int i = 0; i < responses.length; ++i) {
            if (!string.equalsIgnoreCase(responses[i].getShortName())) continue;
            return responses[i];
        }
        if (string.equalsIgnoreCase("POLE_ZERO") && stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return this.seisFrame.getActiveGather().getSeismogram(this.seisFrame.getActiveGather().getActiveSeismogram()).getResponse(this.seisFrame.getDocumentBase(), string2);
        }
        throw new ResponseException(FreqText.response_name_not_found + ": " + string);
    }

    protected void apply() throws ResponseException, FilterException {
        this.transfer.checkSettings();
        this.seisFrame.applyFreqProcess(this.transfer, null, this.getCommandString(), false);
        Seismogram[] seismogramArray = this.seisFrame.getActiveGather().getSeismograms();
        if (seismogramArray != null) {
            for (int i = 0; i < seismogramArray.length; ++i) {
                seismogramArray[i].channel.instName = this.transfer.convertName(seismogramArray[i].channel.instName);
                seismogramArray[i].updateStaInstID();
            }
        }
        this.seisFrame.paintGather();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            this.transfer.setFromResponse(NONE_RESPONSE);
            this.transfer.setToResponse(NONE_RESPONSE);
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("from")) {
                        this.transfer.setFromResponse(this.getResponseFromShortName(stringTokenizer.nextToken(), stringTokenizer));
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("to")) {
                        this.transfer.setToResponse(this.getResponseFromShortName(stringTokenizer.nextToken(), stringTokenizer));
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("freqlimits")) {
                        String[] stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken()};
                        this.transfer.setFreqLimits(stringArray);
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                noSuchElementException.printStackTrace();
            }
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            throw new JToolManagerException("Parsing or applying command: ERROR: " + exception.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        double[] dArray = this.transfer.getFreqLimits();
        String string = this.commandNamesShort[this.variant];
        string = string + " from " + this.transfer.getFromResponse().getShortName() + " to " + this.transfer.getToResponse().getShortName() + " freqlimits " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3];
        return string;
    }

    static {
        Cmplx[] cmplxArray = null;
        Cmplx[] cmplxArray2 = null;
        TransferToolManager.responses[TransferToolManager.count++] = new PoleZeroResponse(1.0, cmplxArray, cmplxArray2, "NONE", SeisGramText.NONE, Response.NO_CONVERSION);
        NONE_RESPONSE = responses[count - 1];
        double d = 0.8;
        double d2 = 0.8;
        double d3 = 2800.0;
        d3 *= 1.0E-6;
        double d4 = Math.PI * 2 / d;
        double d5 = Math.sqrt(1.0 - d2 * d2);
        Cmplx[] cmplxArray3 = new Cmplx[]{new Cmplx(-d4 * d2, d4 * d5), new Cmplx(-d4 * d2, -d4 * d5)};
        Cmplx[] cmplxArray4 = new Cmplx[]{new Cmplx(0.0, 0.0), new Cmplx(0.0, 0.0)};
        String[] stringArray = new String[]{PhysicalUnits.getDefaultLengthUnits()};
        String[] stringArray2 = new String[]{"mm"};
        TransferToolManager.responses[TransferToolManager.count++] = new PoleZeroResponse(d3, cmplxArray3, cmplxArray4, "WA", "Wood-Anderson (Standard)", Response.OTHER_CONVERSION, stringArray, stringArray2, Response.GROUND_DISP_NAME, "W_A_(mm)");
        d = 0.8;
        d2 = 0.7;
        d3 = 2080.0;
        d3 *= 1.0E-6;
        d4 = Math.PI * 2 / d;
        d5 = Math.sqrt(1.0 - d2 * d2);
        cmplxArray3 = new Cmplx[]{new Cmplx(-d4 * d2, d4 * d5), new Cmplx(-d4 * d2, -d4 * d5)};
        cmplxArray4 = new Cmplx[]{new Cmplx(0.0, 0.0), new Cmplx(0.0, 0.0)};
        stringArray = new String[]{PhysicalUnits.getDefaultLengthUnits()};
        stringArray2 = new String[]{"mm"};
        TransferToolManager.responses[TransferToolManager.count++] = new PoleZeroResponse(d3, cmplxArray3, cmplxArray4, "WA_UC1990", "Wood-Anderson (Uhrhammer & Collins, 1990)", Response.OTHER_CONVERSION, stringArray, stringArray2, Response.GROUND_DISP_NAME, "W_A_(mm)");
        Cmplx[] cmplxArray5 = new Cmplx[]{new Cmplx(0.0, 0.0)};
        cmplxArray2 = null;
        TransferToolManager.responses[TransferToolManager.count++] = new PoleZeroResponse(1.0, cmplxArray5, cmplxArray2, "INT", SeisGramText.INTEGRATE, Response.INTEGRAL);
        cmplxArray5 = null;
        cmplxArray2 = new Cmplx[]{new Cmplx(0.0, 0.0)};
        TransferToolManager.responses[TransferToolManager.count++] = new PoleZeroResponse(1.0, cmplxArray5, cmplxArray2, "DIFF", SeisGramText.DIFFERENTIATE, Response.DERIVATIVE);
    }
}

