/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.PeakSlidingWindow;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class PeakSlidingWindowToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected PeakSlidingWindow peakSlidingWindow;
    protected double windowWidthTime = 1.0;
    private static final double WINDOW_WIDTH_MIN = Double.MIN_VALUE;
    private static final double WINDOW_WIDTH_MAX = Double.MAX_VALUE;
    protected double measurementStepTime = 0.0;
    private static final double MEASURE_STEP_MIN = -4.9E-324;
    private static final double MEASURE_STEP_MAX = Double.MAX_VALUE;
    protected AJLJButton buttonApplySmoothing;
    protected JTextField textFieldWindowWidthTime;
    protected JTextField textFieldMeasurementStepTime;
    protected JTextField textFieldThreshold;
    protected JComboBox choiceType;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public PeakSlidingWindowToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.peakSlidingWindow = new PeakSlidingWindow(SeisGramText.getLocaleString(), 999, Double.MAX_VALUE);
        try {
            string = null;
            string = seisGram2KFrame.getParameter("timedom.peakwindow.width");
            if (string != null) {
                this.setWindowWidthTime(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("timedom.peakwindow.threshold");
            if (string != null) {
                this.peakSlidingWindow.setThreshold(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"peakwindow"};
        this.commandNamesShort = new String[]{"pkwin"};
    }

    public void updateLabel() {
        this.label = SeisGramText.SMOOTHING;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void setWindowWidthTime(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_width_value + ": " + d);
        }
        this.windowWidthTime = d;
    }

    public void setWindowWidthTime(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_width_value + ": " + string);
        }
        this.setWindowWidthTime(d);
    }

    public void setMeasurementStepTime(double d) throws TimeDomainException {
        if (d < -4.9E-324 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_measurement_step_value + ": " + d);
        }
        this.measurementStepTime = d;
    }

    public void setMeasurementStepTime(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_measurement_step_value + ": " + string);
        }
        this.setMeasurementStepTime(d);
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplySmoothing = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplySmoothing);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.HALF_WIDTH + " " + SeisGramText.SEC + ":", 4));
        this.textFieldWindowWidthTime = SwingExt.newJTextField(this, this, String.valueOf(this.windowWidthTime), 5);
        jToolBar.add(this.textFieldWindowWidthTime);
        jToolBar.add(new JLabel(SeisGramText.MEASUREMENT_STEP + " " + SeisGramText.SEC + ":", 4));
        this.textFieldMeasurementStepTime = SwingExt.newJTextField(this, this, String.valueOf(this.measurementStepTime), 5);
        jToolBar.add(this.textFieldMeasurementStepTime);
        jToolBar.add(new JLabel(SeisGramText.THRESHOLD_LEVEL + ":", 4));
        this.textFieldThreshold = SwingExt.newJTextField(this, this, String.valueOf(this.peakSlidingWindow.threshold), 5);
        jToolBar.add(this.textFieldThreshold);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplySmoothing)) {
            boolean bl = false;
            try {
                this.setWindowWidthTime(this.textFieldWindowWidthTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldWindowWidthTime.setText(String.valueOf(this.windowWidthTime));
            try {
                this.setMeasurementStepTime(this.textFieldMeasurementStepTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldMeasurementStepTime.setText(String.valueOf(this.measurementStepTime));
            try {
                this.peakSlidingWindow.setThreshold(this.textFieldThreshold.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThreshold.setText(String.valueOf(this.peakSlidingWindow.threshold));
            if (bl) {
                return;
            }
            try {
                this.peakSlidingWindow.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWindowWidthTime)) {
            try {
                this.setWindowWidthTime(this.textFieldWindowWidthTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldWindowWidthTime.setText(String.valueOf(this.windowWidthTime));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMeasurementStepTime)) {
            try {
                this.setMeasurementStepTime(this.textFieldMeasurementStepTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldMeasurementStepTime.setText(String.valueOf(this.measurementStepTime));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThreshold)) {
            try {
                this.peakSlidingWindow.setThreshold(this.textFieldThreshold.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThreshold.setText(String.valueOf(this.peakSlidingWindow.threshold));
            return;
        }
    }

    protected void apply() throws TimeDomainException {
        try {
            double d = this.seisFrame.getActiveGatherSampleInt();
            int n = 1 + (int)(this.windowWidthTime / d);
            this.peakSlidingWindow.setWindowWidth(n);
            int n2 = 1 + (int)(this.measurementStepTime / d);
            this.peakSlidingWindow.setMeasurementStep(n2);
        }
        catch (Exception exception) {
            throw new TimeDomainException(SeisGramText.PEAK_SLIDING_WINDOW + ": " + exception);
        }
        this.peakSlidingWindow.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.peakSlidingWindow, this.getCommandString());
        this.setPicks();
    }

    protected void setPicks() {
        Vector vector = this.peakSlidingWindow.getPickData();
        String string = this.peakSlidingWindow.getPickPrefix();
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            String string2 = string + i;
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string2);
        }
        this.seisFrame.writePicks();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        try {
            this.setWindowWidthTime(this.windowWidthTime);
        }
        catch (Exception exception) {
            throw new JToolManagerException(exception.getMessage());
        }
        try {
            this.setMeasurementStepTime(this.measurementStepTime);
        }
        catch (Exception exception) {
            throw new JToolManagerException(exception.getMessage());
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("wi")) {
                        this.setWindowWidthTime(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("me")) {
                        this.setMeasurementStepTime(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("th")) {
                        this.peakSlidingWindow.setThreshold(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " wi " + this.windowWidthTime;
        string = string + " me " + this.windowWidthTime;
        string = string + " thres " + this.peakSlidingWindow.threshold;
        return string;
    }
}

