/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.freq.FilterException;
import net.alomax.freq.GaussianFilter;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public class GaussianFilterToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected GaussianFilter gaussianFilter;
    protected AJLJButton buttonApplyGaussianFilter;
    protected JTextField textFieldCenterFreq;
    protected JTextField textFieldAlpha;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public GaussianFilterToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.gaussianFilter = new GaussianFilter(SeisGramText.getLocaleString(), 1.0, 10.0);
        this.commandNames = new String[]{"gaussian"};
        this.commandNamesShort = new String[]{"gau"};
    }

    public void updateLabel() {
        this.label = SeisGramText.GAUSSIAN_FILTER;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyGaussianFilter = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyGaussianFilter);
        jToolBar.add(new JLabel(SeisGramText.CENT_FREQ + ":", 4));
        this.textFieldCenterFreq = SwingExt.newJTextField(this, this, String.valueOf(this.gaussianFilter.centFreq), 5);
        jToolBar.add(this.textFieldCenterFreq);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.ALPHA + ":", 4));
        this.textFieldAlpha = SwingExt.newJTextField(this, this, String.valueOf(this.gaussianFilter.alpha), 5);
        jToolBar.add(this.textFieldAlpha);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyGaussianFilter)) {
            boolean bl = false;
            try {
                this.gaussianFilter.setCentFreq(this.textFieldCenterFreq.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                bl = true;
            }
            try {
                this.gaussianFilter.setAlpha(this.textFieldAlpha.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                bl = true;
            }
            this.textFieldCenterFreq.setText(String.valueOf(this.gaussianFilter.centFreq));
            this.textFieldAlpha.setText(String.valueOf(this.gaussianFilter.alpha));
            if (bl) {
                return;
            }
            try {
                this.gaussianFilter.checkSettings();
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldCenterFreq)) {
            try {
                this.gaussianFilter.setCentFreq(this.textFieldCenterFreq.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.textFieldCenterFreq.setText(String.valueOf(this.gaussianFilter.centFreq));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldAlpha)) {
            try {
                this.gaussianFilter.setAlpha(this.textFieldAlpha.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.textFieldAlpha.setText(String.valueOf(this.gaussianFilter.alpha));
            return;
        }
    }

    protected void apply() throws FilterException {
        this.gaussianFilter.checkSettings();
        this.seisFrame.applyFreqProcess(this.gaussianFilter, null, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("fcent")) {
                        this.gaussianFilter.setCentFreq(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("alpha")) {
                        this.gaussianFilter.setAlpha(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (FilterException filterException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + filterException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " fcent " + this.gaussianFilter.centFreq + " alpha " + this.gaussianFilter.alpha;
        return string;
    }
}

