/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.EnergyDuration;
import net.alomax.timedom.TimeDomainException;

public class EnergyDurationToolManager
extends JToolManager {
    protected String[] resultNames = new String[]{"VALUE", "MAGNITUDE"};
    protected SeisGram2KFrame seisFrame = null;
    protected EnergyDuration energyDuration;
    protected AJLJButton buttonApplyEnergyDuration;
    protected JTextField textFieldCoeff;
    protected JTextField textFieldPower;
    protected JComboBox choiceResults;
    protected double coeff = 1.55E10;
    protected double power = 1.5;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public EnergyDurationToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        String string2 = null;
        string2 = "edur.coeff";
        String string3 = seisGram2KFrame.getParameter(string2);
        if (string3 != null) {
            try {
                double d;
                this.coeff = d = Double.valueOf(string3).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string2 + "> value: " + string3);
            }
        }
        if ((string = seisGram2KFrame.getParameter(string2 = "edur.power")) != null) {
            try {
                double d;
                this.power = d = Double.valueOf(string).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string2 + "> value: " + string);
            }
        }
        this.energyDuration = new EnergyDuration(SeisGramText.getLocaleString(), this.coeff, this.power);
        string2 = "edur.result";
        String string4 = seisGram2KFrame.getParameter(string2);
        if (string4 == null) {
            string4 = "VALUE";
        }
        try {
            this.energyDuration.setResultsType(string4);
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string2 + "> value: " + string4);
        }
        this.commandNames = new String[]{"energyduration"};
        this.commandNamesShort = new String[]{"edur"};
    }

    public void updateLabel() {
        this.label = SeisGramText.ENERGY_DURATION;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyEnergyDuration = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyEnergyDuration);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.COEFF + ":", 4));
        this.textFieldCoeff = SwingExt.newJTextField(this, this, String.valueOf(this.energyDuration.coeff), 5);
        jToolBar.add(this.textFieldCoeff);
        jToolBar.add(new JLabel(SeisGramText.POWER + ":", 4));
        this.textFieldPower = SwingExt.newJTextField(this, this, String.valueOf(this.energyDuration.power), 5);
        jToolBar.add(this.textFieldPower);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RESULT + ":", 4));
        this.choiceResults = SwingExt.newChoice(this, this.resultNames);
        this.choiceResults.setSelectedItem(this.energyDuration.getResultsTypeString());
        jToolBar.add(this.choiceResults);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyEnergyDuration)) {
            boolean bl = false;
            try {
                this.energyDuration.setCoeff(this.textFieldCoeff.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldCoeff.setText(String.valueOf(this.energyDuration.coeff));
            if (bl) {
                return;
            }
            try {
                this.energyDuration.setPower(this.textFieldPower.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldPower.setText(String.valueOf(this.energyDuration.power));
            if (bl) {
                return;
            }
            try {
                this.energyDuration.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            try {
                this.energyDuration.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldCoeff)) {
            try {
                this.energyDuration.setCoeff(this.textFieldCoeff.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
        } else {
            if (actionEvent.getSource().equals(this.textFieldPower)) {
                try {
                    this.energyDuration.setPower(this.textFieldPower.getText());
                }
                catch (TimeDomainException timeDomainException) {
                    this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                }
                this.textFieldPower.setText(String.valueOf(this.energyDuration.power));
                return;
            }
            if (actionEvent.getSource().equals(this.choiceResults)) {
                try {
                    this.energyDuration.setResultsType((String)this.choiceResults.getSelectedItem());
                }
                catch (TimeDomainException timeDomainException) {
                    this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                }
                return;
            }
            return;
        }
        this.textFieldCoeff.setText(String.valueOf(this.energyDuration.coeff));
    }

    protected void apply() throws TimeDomainException {
        this.energyDuration.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.energyDuration, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("coef")) {
                        this.energyDuration.setCoeff(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("pow")) {
                        this.energyDuration.setPower(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("res")) {
                        this.energyDuration.setResultsType(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " coeff " + this.energyDuration.coeff;
        string = string + " power " + this.energyDuration.power;
        string = string + " result " + this.energyDuration.getResultsTypeString();
        return string;
    }
}

